/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.csslayout.CSSAlign;
import com.facebook.csslayout.CSSConstants;
import com.facebook.csslayout.CSSFlexDirection;
import com.facebook.csslayout.CSSJustify;
import com.facebook.csslayout.CSSPositionType;
import com.facebook.csslayout.CSSWrap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ViewProps;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import java.util.Locale;
import javax.annotation.Nullable;

public class LayoutShadowNode
extends ReactShadowNode {
    @ReactProp(name="width", defaultFloat=NaNf)
    public void setWidth(float width) {
        this.setStyleWidth(CSSConstants.isUndefined(width) ? width : PixelUtil.toPixelFromDIP(width));
    }

    @ReactProp(name="minWidth", defaultFloat=NaNf)
    public void setMinWidth(float minWidth) {
        this.setStyleMinWidth(CSSConstants.isUndefined(minWidth) ? minWidth : PixelUtil.toPixelFromDIP(minWidth));
    }

    @ReactProp(name="maxWidth", defaultFloat=NaNf)
    public void setMaxWidth(float maxWidth) {
        this.setStyleMaxWidth(CSSConstants.isUndefined(maxWidth) ? maxWidth : PixelUtil.toPixelFromDIP(maxWidth));
    }

    @ReactProp(name="height", defaultFloat=NaNf)
    public void setHeight(float height) {
        this.setStyleHeight(CSSConstants.isUndefined(height) ? height : PixelUtil.toPixelFromDIP(height));
    }

    @ReactProp(name="minHeight", defaultFloat=NaNf)
    public void setMinHeight(float minHeight) {
        this.setStyleMinHeight(CSSConstants.isUndefined(minHeight) ? minHeight : PixelUtil.toPixelFromDIP(minHeight));
    }

    @ReactProp(name="maxHeight", defaultFloat=NaNf)
    public void setMaxHeight(float maxHeight) {
        this.setStyleMaxHeight(CSSConstants.isUndefined(maxHeight) ? maxHeight : PixelUtil.toPixelFromDIP(maxHeight));
    }

    @Override
    @ReactProp(name="flex", defaultFloat=0.0f)
    public void setFlex(float flex) {
        super.setFlex(flex);
    }

    @ReactProp(name="flexDirection")
    public void setFlexDirection(@Nullable String flexDirection) {
        this.setFlexDirection(flexDirection == null ? CSSFlexDirection.COLUMN : CSSFlexDirection.valueOf(flexDirection.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="flexWrap")
    public void setFlexWrap(@Nullable String flexWrap) {
        this.setWrap(flexWrap == null ? CSSWrap.NOWRAP : CSSWrap.valueOf(flexWrap.toUpperCase(Locale.US)));
    }

    @ReactProp(name="alignSelf")
    public void setAlignSelf(@Nullable String alignSelf) {
        this.setAlignSelf(alignSelf == null ? CSSAlign.AUTO : CSSAlign.valueOf(alignSelf.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="alignItems")
    public void setAlignItems(@Nullable String alignItems) {
        this.setAlignItems(alignItems == null ? CSSAlign.STRETCH : CSSAlign.valueOf(alignItems.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactProp(name="justifyContent")
    public void setJustifyContent(@Nullable String justifyContent) {
        this.setJustifyContent(justifyContent == null ? CSSJustify.FLEX_START : CSSJustify.valueOf(justifyContent.toUpperCase(Locale.US).replace("-", "_")));
    }

    @ReactPropGroup(names={"margin", "marginVertical", "marginHorizontal", "marginLeft", "marginRight", "marginTop", "marginBottom"}, defaultFloat=NaNf)
    public void setMargins(int index, float margin) {
        this.setMargin(ViewProps.PADDING_MARGIN_SPACING_TYPES[index], PixelUtil.toPixelFromDIP(margin));
    }

    @ReactPropGroup(names={"padding", "paddingVertical", "paddingHorizontal", "paddingLeft", "paddingRight", "paddingTop", "paddingBottom"}, defaultFloat=NaNf)
    public void setPaddings(int index, float padding) {
        this.setPadding(ViewProps.PADDING_MARGIN_SPACING_TYPES[index], CSSConstants.isUndefined(padding) ? padding : PixelUtil.toPixelFromDIP(padding));
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth"}, defaultFloat=NaNf)
    public void setBorderWidths(int index, float borderWidth) {
        this.setBorder(ViewProps.BORDER_SPACING_TYPES[index], PixelUtil.toPixelFromDIP(borderWidth));
    }

    @ReactPropGroup(names={"left", "right", "top", "bottom"}, defaultFloat=NaNf)
    public void setPositionValues(int index, float position) {
        this.setPosition(ViewProps.POSITION_SPACING_TYPES[index], CSSConstants.isUndefined(position) ? position : PixelUtil.toPixelFromDIP(position));
    }

    @ReactProp(name="position")
    public void setPosition(@Nullable String position) {
        CSSPositionType positionType = position == null ? CSSPositionType.RELATIVE : CSSPositionType.valueOf(position.toUpperCase(Locale.US));
        this.setPositionType(positionType);
    }

    @Override
    @ReactProp(name="onLayout")
    public void setShouldNotifyOnLayout(boolean shouldNotifyOnLayout) {
        super.setShouldNotifyOnLayout(shouldNotifyOnLayout);
    }
}

