/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.Choreographer;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.UiThreadUtil;
import java.util.ArrayDeque;

public class ReactChoreographer {
    private static ReactChoreographer sInstance;
    private final Choreographer mChoreographer = Choreographer.getInstance();
    private final ReactChoreographerDispatcher mReactChoreographerDispatcher = new ReactChoreographerDispatcher();
    private final ArrayDeque<Choreographer.FrameCallback>[] mCallbackQueues = new ArrayDeque[CallbackType.values().length];
    private int mTotalCallbacks = 0;
    private boolean mHasPostedCallback = false;

    public static ReactChoreographer getInstance() {
        UiThreadUtil.assertOnUiThread();
        if (sInstance == null) {
            sInstance = new ReactChoreographer();
        }
        return sInstance;
    }

    private ReactChoreographer() {
        for (int i = 0; i < this.mCallbackQueues.length; ++i) {
            this.mCallbackQueues[i] = new ArrayDeque();
        }
    }

    public void postFrameCallback(CallbackType type, Choreographer.FrameCallback frameCallback) {
        UiThreadUtil.assertOnUiThread();
        this.mCallbackQueues[type.getOrder()].addLast(frameCallback);
        ++this.mTotalCallbacks;
        Assertions.assertCondition((this.mTotalCallbacks > 0 ? 1 : 0) != 0);
        if (!this.mHasPostedCallback) {
            this.mChoreographer.postFrameCallback((Choreographer.FrameCallback)this.mReactChoreographerDispatcher);
            this.mHasPostedCallback = true;
        }
    }

    public void removeFrameCallback(CallbackType type, Choreographer.FrameCallback frameCallback) {
        UiThreadUtil.assertOnUiThread();
        if (this.mCallbackQueues[type.getOrder()].removeFirstOccurrence(frameCallback)) {
            --this.mTotalCallbacks;
            this.maybeRemoveFrameCallback();
        } else {
            FLog.e((String)"React", (String)"Tried to remove non-existent frame callback");
        }
    }

    private void maybeRemoveFrameCallback() {
        Assertions.assertCondition((this.mTotalCallbacks >= 0 ? 1 : 0) != 0);
        if (this.mTotalCallbacks == 0 && this.mHasPostedCallback) {
            this.mChoreographer.removeFrameCallback((Choreographer.FrameCallback)this.mReactChoreographerDispatcher);
            this.mHasPostedCallback = false;
        }
    }

    private class ReactChoreographerDispatcher
    implements Choreographer.FrameCallback {
        private ReactChoreographerDispatcher() {
        }

        public void doFrame(long frameTimeNanos) {
            ReactChoreographer.this.mHasPostedCallback = false;
            for (int i = 0; i < ReactChoreographer.this.mCallbackQueues.length; ++i) {
                int initialLength = ReactChoreographer.this.mCallbackQueues[i].size();
                for (int callback = 0; callback < initialLength; ++callback) {
                    ((Choreographer.FrameCallback)ReactChoreographer.this.mCallbackQueues[i].removeFirst()).doFrame(frameTimeNanos);
                    ReactChoreographer.this.mTotalCallbacks--;
                }
            }
            ReactChoreographer.this.maybeRemoveFrameCallback();
        }
    }

    public static enum CallbackType {
        PERF_MARKERS(0),
        DISPATCH_UI(1),
        NATIVE_ANIMATED_MODULE(2),
        TIMERS_EVENTS(3),
        IDLE_EVENT(4);

        private final int mOrder;

        private CallbackType(int order) {
            this.mOrder = order;
        }

        int getOrder() {
            return this.mOrder;
        }
    }
}

