/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import com.facebook.react.animation.Animation;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIImplementation;
import com.facebook.react.uimanager.UIManagerModuleConstantsHelper;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.debug.NotThreadSafeViewHierarchyUpdateDebugListener;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class UIManagerModule
extends ReactContextBaseJavaModule
implements OnBatchCompleteListener,
LifecycleEventListener {
    private static final int ROOT_VIEW_TAG_INCREMENT = 10;
    private static final boolean DEBUG = false;
    private final EventDispatcher mEventDispatcher;
    private final Map<String, Object> mModuleConstants;
    private final UIImplementation mUIImplementation;
    private int mNextRootViewTag = 1;
    private int mBatchId = 0;

    public UIManagerModule(ReactApplicationContext reactContext, List<ViewManager> viewManagerList, UIImplementation uiImplementation) {
        super(reactContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized((Context)reactContext);
        this.mEventDispatcher = new EventDispatcher(reactContext);
        this.mModuleConstants = UIManagerModule.createConstants(viewManagerList);
        this.mUIImplementation = uiImplementation;
        reactContext.addLifecycleEventListener(this);
    }

    public UIImplementation getUIImplementation() {
        return this.mUIImplementation;
    }

    @Override
    public String getName() {
        return "RKUIManager";
    }

    @Override
    public Map<String, Object> getConstants() {
        return this.mModuleConstants;
    }

    @Override
    public void onHostResume() {
        this.mUIImplementation.onHostResume();
    }

    @Override
    public void onHostPause() {
        this.mUIImplementation.onHostPause();
    }

    @Override
    public void onHostDestroy() {
        this.mUIImplementation.onHostDestroy();
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        this.mEventDispatcher.onCatalystInstanceDestroyed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> createConstants(List<ViewManager> viewManagerList) {
        Systrace.beginSection(0L, "CreateUIManagerConstants");
        try {
            Map<String, Object> map = UIManagerModuleConstantsHelper.createConstants(viewManagerList);
            return map;
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public int addMeasuredRootView(SizeMonitoringFrameLayout rootView) {
        int height;
        int width;
        final int tag = this.mNextRootViewTag;
        this.mNextRootViewTag += 10;
        if (rootView.getLayoutParams() != null && rootView.getLayoutParams().width > 0 && rootView.getLayoutParams().height > 0) {
            width = rootView.getLayoutParams().width;
            height = rootView.getLayoutParams().height;
        } else {
            width = rootView.getWidth();
            height = rootView.getHeight();
        }
        ThemedReactContext themedRootContext = new ThemedReactContext(this.getReactApplicationContext(), rootView.getContext());
        this.mUIImplementation.registerRootView(rootView, tag, width, height, themedRootContext);
        rootView.setOnSizeChangedListener(new SizeMonitoringFrameLayout.OnSizeChangedListener(){

            @Override
            public void onSizeChanged(final int width, final int height, int oldW, int oldH) {
                UIManagerModule.this.getReactApplicationContext().runOnNativeModulesQueueThread(new Runnable(){

                    @Override
                    public void run() {
                        UIManagerModule.this.updateRootNodeSize(tag, width, height);
                    }
                });
            }
        });
        return tag;
    }

    @ReactMethod
    public void removeRootView(int rootViewTag) {
        this.mUIImplementation.removeRootView(rootViewTag);
    }

    private void updateRootNodeSize(int rootViewTag, int newWidth, int newHeight) {
        this.getReactApplicationContext().assertOnNativeModulesQueueThread();
        this.mUIImplementation.updateRootNodeSize(rootViewTag, newWidth, newHeight, this.mEventDispatcher);
    }

    @ReactMethod
    public void createView(int tag, String className, int rootViewTag, ReadableMap props) {
        this.mUIImplementation.createView(tag, className, rootViewTag, props);
    }

    @ReactMethod
    public void updateView(int tag, String className, ReadableMap props) {
        this.mUIImplementation.updateView(tag, className, props);
    }

    @ReactMethod
    public void manageChildren(int viewTag, @Nullable ReadableArray moveFrom, @Nullable ReadableArray moveTo, @Nullable ReadableArray addChildTags, @Nullable ReadableArray addAtIndices, @Nullable ReadableArray removeFrom) {
        this.mUIImplementation.manageChildren(viewTag, moveFrom, moveTo, addChildTags, addAtIndices, removeFrom);
    }

    @ReactMethod
    public void setChildren(int viewTag, ReadableArray childrenTags) {
        this.mUIImplementation.setChildren(viewTag, childrenTags);
    }

    @ReactMethod
    public void replaceExistingNonRootView(int oldTag, int newTag) {
        this.mUIImplementation.replaceExistingNonRootView(oldTag, newTag);
    }

    @ReactMethod
    public void removeSubviewsFromContainerWithID(int containerTag) {
        this.mUIImplementation.removeSubviewsFromContainerWithID(containerTag);
    }

    @ReactMethod
    public void measure(int reactTag, Callback callback) {
        this.mUIImplementation.measure(reactTag, callback);
    }

    @ReactMethod
    public void measureInWindow(int reactTag, Callback callback) {
        this.mUIImplementation.measureInWindow(reactTag, callback);
    }

    @ReactMethod
    public void measureLayout(int tag, int ancestorTag, Callback errorCallback, Callback successCallback) {
        this.mUIImplementation.measureLayout(tag, ancestorTag, errorCallback, successCallback);
    }

    @ReactMethod
    public void measureLayoutRelativeToParent(int tag, Callback errorCallback, Callback successCallback) {
        this.mUIImplementation.measureLayoutRelativeToParent(tag, errorCallback, successCallback);
    }

    @ReactMethod
    public void findSubviewIn(int reactTag, ReadableArray point, Callback callback) {
        this.mUIImplementation.findSubviewIn(reactTag, Math.round(PixelUtil.toPixelFromDIP(point.getDouble(0))), Math.round(PixelUtil.toPixelFromDIP(point.getDouble(1))), callback);
    }

    public void registerAnimation(Animation animation) {
        this.mUIImplementation.registerAnimation(animation);
    }

    public void addAnimation(int reactTag, int animationID, Callback onSuccess) {
        this.mUIImplementation.addAnimation(reactTag, animationID, onSuccess);
    }

    public void removeAnimation(int reactTag, int animationID) {
        this.mUIImplementation.removeAnimation(reactTag, animationID);
    }

    @ReactMethod
    public void setJSResponder(int reactTag, boolean blockNativeResponder) {
        this.mUIImplementation.setJSResponder(reactTag, blockNativeResponder);
    }

    @ReactMethod
    public void clearJSResponder() {
        this.mUIImplementation.clearJSResponder();
    }

    @ReactMethod
    public void dispatchViewManagerCommand(int reactTag, int commandId, ReadableArray commandArgs) {
        this.mUIImplementation.dispatchViewManagerCommand(reactTag, commandId, commandArgs);
    }

    @ReactMethod
    public void showPopupMenu(int reactTag, ReadableArray items, Callback error, Callback success) {
        this.mUIImplementation.showPopupMenu(reactTag, items, error, success);
    }

    @ReactMethod
    public void setLayoutAnimationEnabledExperimental(boolean enabled) {
        this.mUIImplementation.setLayoutAnimationEnabledExperimental(enabled);
    }

    @ReactMethod
    public void configureNextLayoutAnimation(ReadableMap config, Callback success, Callback error) {
        this.mUIImplementation.configureNextLayoutAnimation(config, success, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBatchComplete() {
        int batchId = this.mBatchId++;
        SystraceMessage.beginSection(0L, "onBatchCompleteUI").arg("BatchId", batchId).flush();
        try {
            this.mUIImplementation.dispatchViewUpdates(this.mEventDispatcher, batchId);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void setViewHierarchyUpdateDebugListener(@Nullable NotThreadSafeViewHierarchyUpdateDebugListener listener) {
        this.mUIImplementation.setViewHierarchyUpdateDebugListener(listener);
    }

    public EventDispatcher getEventDispatcher() {
        return this.mEventDispatcher;
    }

    @ReactMethod
    public void sendAccessibilityEvent(int tag, int eventType) {
        this.mUIImplementation.sendAccessibilityEvent(tag, eventType);
    }

    public void addUIBlock(UIBlock block) {
        this.mUIImplementation.addUIBlock(block);
    }
}

