/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.art;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.views.art.ARTVirtualNode;

public class ARTSurfaceViewShadowNode
extends LayoutShadowNode {
    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isVirtualAnchor() {
        return true;
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiUpdater) {
        super.onCollectExtraUpdates(uiUpdater);
        uiUpdater.enqueueUpdateExtraData(this.getReactTag(), this.drawOutput());
    }

    private Object drawOutput() {
        Bitmap bitmap = Bitmap.createBitmap((int)((int)this.getLayoutWidth()), (int)((int)this.getLayoutHeight()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        for (int i = 0; i < this.getChildCount(); ++i) {
            ARTVirtualNode child = (ARTVirtualNode)this.getChildAt(i);
            child.draw(canvas, paint, 1.0f);
            child.markUpdateSeen();
        }
        return bitmap;
    }
}

