/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.Nullable;

public class ImageLoadEvent
extends Event<ImageLoadEvent> {
    public static final int ON_ERROR = 1;
    public static final int ON_LOAD = 2;
    public static final int ON_LOAD_END = 3;
    public static final int ON_LOAD_START = 4;
    public static final int ON_PROGRESS = 5;
    private final int mEventType;
    @Nullable
    private final String mImageUri;

    public ImageLoadEvent(int viewId, int eventType) {
        this(viewId, eventType, null);
    }

    public ImageLoadEvent(int viewId, int eventType, @Nullable String imageUri) {
        super(viewId);
        this.mEventType = eventType;
        this.mImageUri = imageUri;
    }

    public static String eventNameForType(int eventType) {
        switch (eventType) {
            case 1: {
                return "topError";
            }
            case 2: {
                return "topLoad";
            }
            case 3: {
                return "topLoadEnd";
            }
            case 4: {
                return "topLoadStart";
            }
            case 5: {
                return "topProgress";
            }
        }
        throw new IllegalStateException("Invalid image event: " + Integer.toString(eventType));
    }

    @Override
    public String getEventName() {
        return ImageLoadEvent.eventNameForType(this.mEventType);
    }

    @Override
    public short getCoalescingKey() {
        return (short)this.mEventType;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        WritableMap eventData = null;
        if (this.mImageUri != null) {
            eventData = Arguments.createMap();
            eventData.putString("uri", this.mImageUri);
        }
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), eventData);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ImageEventType {
    }
}

