/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.modal;

import android.annotation.TargetApi;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;
import com.facebook.csslayout.CSSNode;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;

class ModalHostShadowNode
extends LayoutShadowNode {
    private final Point mMinPoint = new Point();
    private final Point mMaxPoint = new Point();

    ModalHostShadowNode() {
    }

    @Override
    @TargetApi(value=16)
    public void addChildAt(CSSNode child, int i) {
        int height;
        int width;
        super.addChildAt(child, i);
        ThemedReactContext context = this.getThemedContext();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        display.getCurrentSizeRange(this.mMinPoint, this.mMaxPoint);
        int rotation = display.getRotation();
        if (rotation == 0 || rotation == 2) {
            width = this.mMinPoint.x;
            height = this.mMaxPoint.y;
        } else {
            width = this.mMaxPoint.x;
            height = this.mMinPoint.y;
        }
        child.setStyleWidth(width);
        child.setStyleHeight(height);
    }
}

