/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.recyclerview;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.recyclerview.ContentSizeChangeEvent;
import com.facebook.react.views.recyclerview.NotAnimatedItemAnimator;
import com.facebook.react.views.scroll.ScrollEvent;
import com.facebook.react.views.scroll.ScrollEventType;
import java.util.ArrayList;
import java.util.List;

@VisibleForTesting
public class RecyclerViewBackedScrollView
extends RecyclerView {
    private boolean mSendContentSizeChangeEvents;

    public void setSendContentSizeChangeEvents(boolean sendContentSizeChangeEvents) {
        this.mSendContentSizeChangeEvents = sendContentSizeChangeEvents;
    }

    private int calculateAbsoluteOffset() {
        int offsetY = 0;
        if (this.getChildCount() > 0) {
            View recyclerViewChild = this.getChildAt(0);
            int childPosition = this.getChildViewHolder(recyclerViewChild).getLayoutPosition();
            offsetY = ((ReactListAdapter)this.getAdapter()).getTopOffsetForItem(childPosition) - recyclerViewChild.getTop();
        }
        return offsetY;
    }

    void scrollTo(int scrollX, int scrollY, boolean animated) {
        int deltaY = scrollY - this.calculateAbsoluteOffset();
        if (animated) {
            this.smoothScrollBy(0, deltaY);
        } else {
            this.scrollBy(0, deltaY);
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        ((ReactContext)this.getContext()).getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(ScrollEvent.obtain(this.getId(), ScrollEventType.SCROLL, 0, this.calculateAbsoluteOffset(), this.getWidth(), ((ReactListAdapter)this.getAdapter()).getTotalChildrenHeight(), this.getWidth(), this.getHeight()));
    }

    private void onTotalChildrenHeightChange(int newTotalChildrenHeight) {
        if (this.mSendContentSizeChangeEvents) {
            ((ReactContext)this.getContext()).getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(new ContentSizeChangeEvent(this.getId(), this.getWidth(), newTotalChildrenHeight));
        }
    }

    public RecyclerViewBackedScrollView(Context context) {
        super(context);
        this.setHasFixedSize(true);
        this.setItemAnimator(new NotAnimatedItemAnimator());
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.setAdapter(new ReactListAdapter(this));
    }

    void addViewToAdapter(View child, int index) {
        ((ReactListAdapter)this.getAdapter()).addView(child, index);
    }

    void removeViewFromAdapter(int index) {
        ((ReactListAdapter)this.getAdapter()).removeViewAt(index);
    }

    View getChildAtFromAdapter(int index) {
        return ((ReactListAdapter)this.getAdapter()).getView(index);
    }

    int getChildCountFromAdapter() {
        return this.getAdapter().getItemCount();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
            return true;
        }
        return false;
    }

    static class ReactListAdapter
    extends RecyclerView.Adapter<ConcreteViewHolder> {
        private final List<View> mViews = new ArrayList<View>();
        private final ScrollOffsetTracker mScrollOffsetTracker;
        private final RecyclerViewBackedScrollView mScrollView;
        private int mTotalChildrenHeight = 0;
        private final View.OnLayoutChangeListener mChildLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                int oldHeight = oldBottom - oldTop;
                int newHeight = bottom - top;
                if (oldHeight != newHeight) {
                    ReactListAdapter.this.updateTotalChildrenHeight(newHeight - oldHeight);
                    ReactListAdapter.this.mScrollOffsetTracker.onHeightChange(ReactListAdapter.this.mViews.indexOf(v), oldHeight, newHeight);
                    if (v.getParent() != null && v.getParent().getParent() != null) {
                        View wrapper = (View)v.getParent();
                        wrapper.forceLayout();
                        ((View)wrapper.getParent()).forceLayout();
                    }
                }
            }
        };

        public ReactListAdapter(RecyclerViewBackedScrollView scrollView) {
            this.mScrollView = scrollView;
            this.mScrollOffsetTracker = new ScrollOffsetTracker(this);
            this.setHasStableIds(true);
        }

        public void addView(View child, int index) {
            this.mViews.add(index, child);
            this.updateTotalChildrenHeight(child.getMeasuredHeight());
            child.addOnLayoutChangeListener(this.mChildLayoutChangeListener);
            this.notifyItemInserted(index);
        }

        public void removeViewAt(int index) {
            View child = this.mViews.get(index);
            if (child != null) {
                this.mViews.remove(index);
                child.removeOnLayoutChangeListener(this.mChildLayoutChangeListener);
                this.updateTotalChildrenHeight(-child.getMeasuredHeight());
                this.notifyItemRemoved(index);
            }
        }

        private void updateTotalChildrenHeight(int delta) {
            if (delta != 0) {
                this.mTotalChildrenHeight += delta;
                this.mScrollView.onTotalChildrenHeightChange(this.mTotalChildrenHeight);
            }
        }

        public ConcreteViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new ConcreteViewHolder((View)new RecyclableWrapperViewGroup(parent.getContext()));
        }

        public void onBindViewHolder(ConcreteViewHolder holder, int position) {
            RecyclableWrapperViewGroup vg = (RecyclableWrapperViewGroup)holder.itemView;
            View row = this.mViews.get(position);
            if (row.getParent() != vg) {
                vg.addView(row, 0);
            }
        }

        public void onViewRecycled(ConcreteViewHolder holder) {
            super.onViewRecycled((RecyclerView.ViewHolder)holder);
            ((RecyclableWrapperViewGroup)holder.itemView).removeAllViews();
        }

        public int getItemCount() {
            return this.mViews.size();
        }

        public long getItemId(int position) {
            return this.mViews.get(position).getId();
        }

        public View getView(int index) {
            return this.mViews.get(index);
        }

        public int getTotalChildrenHeight() {
            return this.mTotalChildrenHeight;
        }

        public int getTopOffsetForItem(int index) {
            return this.mScrollOffsetTracker.getTopOffsetForItem(index);
        }
    }

    private static class ScrollOffsetTracker {
        private final ReactListAdapter mReactListAdapter;
        private int mLastRequestedPosition;
        private int mOffsetForLastPosition;

        private ScrollOffsetTracker(ReactListAdapter reactListAdapter) {
            this.mReactListAdapter = reactListAdapter;
        }

        public void onHeightChange(int index, int oldHeight, int newHeight) {
            if (index < this.mLastRequestedPosition) {
                this.mOffsetForLastPosition = this.mOffsetForLastPosition - oldHeight + newHeight;
            }
        }

        public int getTopOffsetForItem(int index) {
            if (this.mLastRequestedPosition != index) {
                int sum;
                if (this.mLastRequestedPosition < index) {
                    int startIndex;
                    if (this.mLastRequestedPosition != -1) {
                        sum = this.mOffsetForLastPosition;
                        startIndex = this.mLastRequestedPosition;
                    } else {
                        sum = 0;
                        startIndex = 0;
                    }
                    for (int i = startIndex; i < index; ++i) {
                        sum += ((View)this.mReactListAdapter.mViews.get(i)).getMeasuredHeight();
                    }
                } else if (index < this.mLastRequestedPosition - index) {
                    sum = 0;
                    for (int i = 0; i < index; ++i) {
                        sum += ((View)this.mReactListAdapter.mViews.get(i)).getMeasuredHeight();
                    }
                } else {
                    sum = this.mOffsetForLastPosition;
                    for (int i = this.mLastRequestedPosition - 1; i >= index; --i) {
                        sum -= ((View)this.mReactListAdapter.mViews.get(i)).getMeasuredHeight();
                    }
                }
                this.mLastRequestedPosition = index;
                this.mOffsetForLastPosition = sum;
            }
            return this.mOffsetForLastPosition;
        }
    }

    private static class RecyclableWrapperViewGroup
    extends ViewGroup {
        public RecyclableWrapperViewGroup(Context context) {
            super(context);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                this.setMeasuredDimension(child.getMeasuredWidth(), child.getMeasuredHeight());
            } else {
                Assertions.assertUnreachable((String)"RecyclableWrapperView measured but no view attached");
            }
        }
    }

    private static class ConcreteViewHolder
    extends RecyclerView.ViewHolder {
        public ConcreteViewHolder(View itemView) {
            super(itemView);
        }
    }
}

