/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.PixelUtil;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactScrollViewCommandHelper {
    public static final int COMMAND_SCROLL_TO = 1;

    public static Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("scrollTo", 1);
    }

    public static <T> void receiveCommand(ScrollCommandHandler<T> viewManager, T scrollView, int commandType, @Nullable ReadableArray args) {
        Assertions.assertNotNull(viewManager);
        Assertions.assertNotNull(scrollView);
        Assertions.assertNotNull((Object)args);
        switch (commandType) {
            case 1: {
                int destX = Math.round(PixelUtil.toPixelFromDIP(args.getDouble(0)));
                int destY = Math.round(PixelUtil.toPixelFromDIP(args.getDouble(1)));
                boolean animated = args.getBoolean(2);
                viewManager.scrollTo(scrollView, new ScrollToCommandData(destX, destY, animated));
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported command %d received by %s.", commandType, viewManager.getClass().getSimpleName()));
    }

    public static class ScrollToCommandData {
        public final int mDestX;
        public final int mDestY;
        public final boolean mAnimated;

        ScrollToCommandData(int destX, int destY, boolean animated) {
            this.mDestX = destX;
            this.mDestY = destY;
            this.mAnimated = animated;
        }
    }

    public static interface ScrollCommandHandler<T> {
        public void scrollTo(T var1, ScrollToCommandData var2);
    }
}

