/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.text.Spannable;
import com.facebook.csslayout.Spacing;

public class ReactTextUpdate {
    private final Spannable mText;
    private final int mJsEventCounter;
    private final boolean mContainsImages;
    private final float mPaddingLeft;
    private final float mPaddingTop;
    private final float mPaddingRight;
    private final float mPaddingBottom;
    private final float mLineHeight;
    private final int mTextAlign;

    public ReactTextUpdate(Spannable text, int jsEventCounter, boolean containsImages, Spacing padding, float lineHeight, int textAlign) {
        this.mText = text;
        this.mJsEventCounter = jsEventCounter;
        this.mContainsImages = containsImages;
        this.mPaddingLeft = padding.get(4);
        this.mPaddingTop = padding.get(1);
        this.mPaddingRight = padding.get(5);
        this.mPaddingBottom = padding.get(3);
        this.mLineHeight = lineHeight;
        this.mTextAlign = textAlign;
    }

    public Spannable getText() {
        return this.mText;
    }

    public int getJsEventCounter() {
        return this.mJsEventCounter;
    }

    public boolean containsImages() {
        return this.mContainsImages;
    }

    public float getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public float getPaddingTop() {
        return this.mPaddingTop;
    }

    public float getPaddingRight() {
        return this.mPaddingRight;
    }

    public float getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public float getLineHeight() {
        return this.mLineHeight;
    }

    public int getTextAlign() {
        return this.mTextAlign;
    }
}

