/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.text.Spannable;
import android.view.ViewGroup;
import android.widget.EditText;
import com.facebook.csslayout.CSSDirection;
import com.facebook.csslayout.CSSMeasureMode;
import com.facebook.csslayout.CSSNodeAPI;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.csslayout.Spacing;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactTextShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.view.MeasureUtil;
import javax.annotation.Nullable;

@VisibleForTesting
public class ReactTextInputShadowNode
extends ReactTextShadowNode
implements CSSNodeAPI.MeasureFunction {
    @Nullable
    private EditText mEditText;
    @Nullable
    private float[] mComputedPadding;
    private int mJsEventCount = -1;

    public ReactTextInputShadowNode() {
        super(false);
        this.setMeasureFunction(this);
    }

    @Override
    public void setThemedContext(ThemedReactContext themedContext) {
        super.setThemedContext(themedContext);
        this.mEditText = new EditText((Context)this.getThemedContext());
        this.mEditText.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.setDefaultPadding(4, this.mEditText.getPaddingStart());
        this.setDefaultPadding(1, this.mEditText.getPaddingTop());
        this.setDefaultPadding(5, this.mEditText.getPaddingEnd());
        this.setDefaultPadding(3, this.mEditText.getPaddingBottom());
        this.mComputedPadding = this.spacingToFloatArray(this.getPadding());
    }

    @Override
    public void measure(CSSNodeAPI node, float width, CSSMeasureMode widthMode, float height, CSSMeasureMode heightMode, MeasureOutput measureOutput) {
        EditText editText = (EditText)Assertions.assertNotNull((Object)this.mEditText);
        editText.setTextSize(0, this.mFontSize == -1 ? (float)((int)Math.ceil(PixelUtil.toPixelFromSP(14.0f))) : (float)this.mFontSize);
        this.mComputedPadding = this.spacingToFloatArray(this.getPadding());
        editText.setPadding((int)Math.ceil(this.getPadding().get(4)), (int)Math.ceil(this.getPadding().get(1)), (int)Math.ceil(this.getPadding().get(5)), (int)Math.ceil(this.getPadding().get(3)));
        if (this.mNumberOfLines != -1) {
            editText.setLines(this.mNumberOfLines);
        }
        editText.measure(MeasureUtil.getMeasureSpec(width, widthMode), MeasureUtil.getMeasureSpec(height, heightMode));
        measureOutput.width = editText.getMeasuredWidth();
        measureOutput.height = editText.getMeasuredHeight();
    }

    @Override
    public void onBeforeLayout() {
    }

    @ReactProp(name="mostRecentEventCount")
    public void setMostRecentEventCount(int mostRecentEventCount) {
        this.mJsEventCount = mostRecentEventCount;
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mComputedPadding != null) {
            float[] updatedPadding = this.mComputedPadding;
            if (this.getLayoutDirection() == CSSDirection.RTL) {
                updatedPadding = this.spacingToFloatArrayForRTL(this.getPadding());
            }
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), updatedPadding);
            this.mComputedPadding = null;
        }
        if (this.mJsEventCount != -1) {
            Spannable preparedSpannableText = ReactTextInputShadowNode.fromTextCSSNode(this);
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(preparedSpannableText, this.mJsEventCount, this.mContainsImages, this.getPadding(), this.getEffectiveLineHeight(), this.mTextAlign);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    @Override
    public void setPadding(int spacingType, float padding) {
        super.setPadding(spacingType, padding);
        this.mComputedPadding = this.spacingToFloatArray(this.getPadding());
        this.markUpdated();
    }

    private float[] spacingToFloatArray(Spacing spacing) {
        return new float[]{spacing.get(4), spacing.get(1), spacing.get(5), spacing.get(3)};
    }

    private float[] spacingToFloatArrayForRTL(Spacing spacing) {
        return new float[]{spacing.get(5), spacing.get(1), spacing.get(4), spacing.get(3)};
    }
}

