/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.viewpager;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.RCTEventEmitter;

class PageScrollEvent
extends Event<PageScrollEvent> {
    public static final String EVENT_NAME = "topPageScroll";
    private final int mPosition;
    private final float mOffset;

    protected PageScrollEvent(int viewTag, int position, float offset) {
        super(viewTag);
        this.mPosition = position;
        this.mOffset = offset;
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public void dispatch(RCTEventEmitter rctEventEmitter) {
        rctEventEmitter.receiveEvent(this.getViewTag(), this.getEventName(), this.serializeEventData());
    }

    private WritableMap serializeEventData() {
        WritableMap eventData = Arguments.createMap();
        eventData.putInt("position", this.mPosition);
        eventData.putDouble("offset", this.mOffset);
        return eventData;
    }
}

