/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.crypt;

import android.content.Context;
import com.getui.gtc.base.GtcProvider;
import com.getui.gtc.base.crypt.CryptException;
import com.getui.gtc.base.crypt.CryptTools;
import com.getui.gtc.base.crypt.d;
import com.getui.gtc.base.util.io.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class SecureCryptTools {
    private static final String CIPHER_FLAG_FIRST = "First";
    private static final String CIPHER_FLAG_SECOND = "Second";
    private static final String CIPHER_FLAG_STARTER = ":::";
    private static final String CIPHER_FLAG_SEPARATOR = "-";
    private d secureKeyStore;
    private volatile boolean initInvoked;
    private ReentrantLock lock = new ReentrantLock();

    private SecureCryptTools() {
        try {
            this.init(GtcProvider.context());
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public static SecureCryptTools getInstance() {
        return a.a;
    }

    private List<CryptException> init(Context object) throws CryptException {
        try {
            this.lock.lock();
            if (this.initInvoked) {
                object = Collections.emptyList();
                return object;
            }
            this.initInvoked = true;
            this.secureKeyStore = new d();
            object = this.secureKeyStore.a((Context)object);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] encrypt(byte[] byArray) throws CryptException {
        if (!this.initInvoked) {
            throw new CryptException("SecureCryptTools: please init firstly!");
        }
        try {
            this.lock.tryLock(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new CryptException("SecureCryptTools: wait init time out!");
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        return this.doEncrypt(byArray);
    }

    public byte[] decrypt(byte[] byArray) throws CryptException {
        if (!this.initInvoked) {
            throw new CryptException("SecureCryptTools: please init firstly!");
        }
        try {
            this.lock.tryLock(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new CryptException("SecureCryptTools: wait init time out!");
        }
        finally {
            if (this.lock.isLocked()) {
                this.lock.unlock();
            }
        }
        return this.doDecrypt(byArray);
    }

    /*
     * Loose catch block
     */
    private byte[] doEncrypt(byte[] byArray) throws CryptException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (this.secureKeyStore.c != null) {
            byte[] byArray3;
            try {
                int n2;
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                byteArrayOutputStream = new ByteArrayOutputStream();
                d d2 = this.secureKeyStore;
                inputStream = CryptTools.encrypt("AES/CBC/PKCS7Padding", d2.a(d2.g), this.secureKeyStore.b(), byteArrayInputStream);
                byArray3 = new byte[256];
                while ((n2 = inputStream.read(byArray3)) != -1) {
                    byteArrayOutputStream.write(byArray3, 0, n2);
                }
                byteArrayOutputStream.flush();
                byArray3 = byteArrayOutputStream.toByteArray();
                byte[] byArray4 = (CIPHER_FLAG_STARTER + this.secureKeyStore.g + "-First").getBytes();
                int n3 = byArray4.length;
                byte[] byArray5 = new byte[byArray3.length + n3];
                System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
                System.arraycopy(byArray4, 0, byArray5, byArray3.length, n3);
                byArray3 = byArray5;
            }
            catch (Throwable throwable) {
                int n4;
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                byteArrayOutputStream = new ByteArrayOutputStream();
                inputStream = CryptTools.encrypt("AES/CBC/PKCS7Padding", this.secureKeyStore.a(), this.secureKeyStore.b(), byteArrayInputStream);
                byte[] byArray6 = new byte[256];
                while ((n4 = inputStream.read(byArray6)) != -1) {
                    byteArrayOutputStream.write(byArray6, 0, n4);
                }
                byteArrayOutputStream.flush();
                byArray6 = byteArrayOutputStream.toByteArray();
                byte[] byArray7 = (CIPHER_FLAG_STARTER + this.secureKeyStore.g + "-Second").getBytes();
                int n5 = byArray7.length;
                byte[] byArray8 = new byte[byArray6.length + n5];
                System.arraycopy(byArray6, 0, byArray8, 0, byArray6.length);
                System.arraycopy(byArray7, 0, byArray8, byArray6.length, n5);
                byArray = byArray8;
                IOUtils.safeClose(inputStream);
                IOUtils.safeClose(byteArrayInputStream);
                IOUtils.safeClose(byteArrayOutputStream);
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            throw new CryptException("encrypt failed", throwable2);
                        }
                        catch (Throwable throwable3) {
                            IOUtils.safeClose(inputStream);
                            IOUtils.safeClose(byteArrayInputStream);
                            IOUtils.safeClose(byteArrayOutputStream);
                            throw throwable3;
                        }
                    }
                }
            }
            IOUtils.safeClose(inputStream);
            IOUtils.safeClose(byteArrayInputStream);
            IOUtils.safeClose(byteArrayOutputStream);
            return byArray3;
        }
        try {
            int n6;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = CryptTools.encrypt("AES/CBC/PKCS7Padding", this.secureKeyStore.a(), this.secureKeyStore.b(), byteArrayInputStream);
            byArray2 = new byte[256];
            while ((n6 = inputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n6);
            }
            byteArrayOutputStream.flush();
            byArray2 = byteArrayOutputStream.toByteArray();
            byte[] byArray9 = (CIPHER_FLAG_STARTER + this.secureKeyStore.g + "-Second").getBytes();
            int n7 = byArray9.length;
            byte[] byArray10 = new byte[byArray2.length + n7];
            System.arraycopy(byArray2, 0, byArray10, 0, byArray2.length);
            System.arraycopy(byArray9, 0, byArray10, byArray2.length, n7);
            byArray2 = byArray10;
        }
        catch (Throwable throwable) {
            try {
                throw new CryptException("encrypt failed", throwable);
            }
            catch (Throwable throwable4) {
                IOUtils.safeClose(inputStream);
                IOUtils.safeClose(byteArrayInputStream);
                throw throwable4;
            }
        }
        IOUtils.safeClose(inputStream);
        IOUtils.safeClose(byteArrayInputStream);
        return byArray2;
    }

    private synchronized byte[] doDecrypt(byte[] byArray) throws CryptException {
        String string = this.getCipherFlag(byArray);
        if (string == null) {
            throw new CryptException("Cipher flag not found in cipher text!");
        }
        Object object = string.split(CIPHER_FLAG_SEPARATOR);
        if (((String[])object).length < 2) {
            throw new CryptException("Cipher flag is wrong in cipher text!");
        }
        object = object[0];
        byArray = Arrays.copyOfRange(byArray, 0, byArray.length - string.length() - 3);
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        InputStream inputStream = null;
        if (string.endsWith(CIPHER_FLAG_FIRST)) {
            try {
                int n2;
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                byteArrayOutputStream = new ByteArrayOutputStream();
                inputStream = CryptTools.decrypt("AES/CBC/PKCS7Padding", this.secureKeyStore.a((String)object), this.secureKeyStore.c((String)object), byteArrayInputStream);
                byArray = new byte[256];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    throw new CryptException("decrypt failed!", throwable);
                }
                catch (Throwable throwable2) {
                    IOUtils.safeClose(inputStream);
                    IOUtils.safeClose(byteArrayInputStream);
                    IOUtils.safeClose(byteArrayOutputStream);
                    throw throwable2;
                }
            }
            IOUtils.safeClose(inputStream);
            IOUtils.safeClose(byteArrayInputStream);
            IOUtils.safeClose(byteArrayOutputStream);
            return byArray;
        }
        if (string.endsWith(CIPHER_FLAG_SECOND)) {
            try {
                int n3;
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                byteArrayOutputStream = new ByteArrayOutputStream();
                inputStream = CryptTools.decrypt("AES/CBC/PKCS7Padding", this.secureKeyStore.b((String)object), this.secureKeyStore.c((String)object), byteArrayInputStream);
                byArray = new byte[256];
                while ((n3 = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n3);
                }
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    throw new CryptException("decrypt failed!", throwable);
                }
                catch (Throwable throwable3) {
                    IOUtils.safeClose(inputStream);
                    IOUtils.safeClose(byteArrayInputStream);
                    IOUtils.safeClose(byteArrayOutputStream);
                    throw throwable3;
                }
            }
            IOUtils.safeClose(inputStream);
            IOUtils.safeClose(byteArrayInputStream);
            IOUtils.safeClose(byteArrayOutputStream);
            return byArray;
        }
        throw new CryptException("Cipher flag not found in cipher text!");
    }

    private String getCipherFlag(byte[] object) {
        String string = new String((byte[])object);
        object = string;
        int n2 = string.lastIndexOf(CIPHER_FLAG_STARTER);
        if (n2 < 0) {
            return null;
        }
        return ((String)object).substring(n2 + 3);
    }

    static final class a {
        private static SecureCryptTools a = new SecureCryptTools();
    }
}

