/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.getui.gtc.base.db.AbstractTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractDb {
    private final Map<Class<? extends AbstractTable>, AbstractTable> tables = new HashMap<Class<? extends AbstractTable>, AbstractTable>();
    private SQLiteOpenHelper helper;
    private final AtomicBoolean inited = new AtomicBoolean(false);

    public abstract String getDbName();

    public abstract int getVersion();

    public final void addTable(Class<? extends AbstractTable> clazz) throws IllegalAccessException, InstantiationException {
        AbstractTable abstractTable = this.tables.get(clazz);
        if (abstractTable == null) {
            abstractTable = clazz.newInstance();
            this.tables.put(clazz, abstractTable);
        }
        abstractTable.setDb(this);
    }

    public final void addTables(List<Class<? extends AbstractTable>> object) throws InstantiationException, IllegalAccessException {
        object = object.iterator();
        while (object.hasNext()) {
            Class clazz = (Class)object.next();
            this.addTable(clazz);
        }
    }

    public final <T extends AbstractTable> T getTable(Class<T> clazz) {
        AbstractTable abstractTable = this.tables.get(clazz);
        if (abstractTable == null) {
            throw new RuntimeException("table " + clazz.getSimpleName() + " has not been added to db " + this.getDbName());
        }
        return (T)abstractTable;
    }

    public final Collection<AbstractTable> getTables() {
        Collection<AbstractTable> collection = this.tables.values();
        if (collection.size() <= 0) {
            throw new RuntimeException("no table has been added to db " + this.getDbName());
        }
        return collection;
    }

    public final SQLiteOpenHelper getHelper() {
        if (this.helper == null) {
            throw new RuntimeException("db " + this.getDbName() + " has not been initialized");
        }
        return this.helper;
    }

    public void init(Context context) {
        if (!this.inited.getAndSet(true)) {
            this.helper = new SQLiteOpenHelper(context, this.getDbName(), null, this.getVersion()){

                public void onCreate(SQLiteDatabase sQLiteDatabase) {
                    try {
                        sQLiteDatabase.beginTransaction();
                        try {
                            for (Class clazz : AbstractDb.this.tables.keySet()) {
                                sQLiteDatabase.execSQL(((AbstractTable)AbstractDb.this.tables.get(clazz)).createSql());
                            }
                            sQLiteDatabase.setTransactionSuccessful();
                            return;
                        }
                        finally {
                            sQLiteDatabase.endTransaction();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }

                public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
                    try {
                        sQLiteDatabase.beginTransaction();
                        try {
                            for (Class clazz : AbstractDb.this.tables.keySet()) {
                                ((AbstractTable)AbstractDb.this.tables.get(clazz)).onUpgrade(sQLiteDatabase, n2, n3);
                            }
                            sQLiteDatabase.setTransactionSuccessful();
                            return;
                        }
                        finally {
                            sQLiteDatabase.endTransaction();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }

                public void onDowngrade(SQLiteDatabase sQLiteDatabase, int n2, int n3) {
                    try {
                        sQLiteDatabase.beginTransaction();
                        try {
                            for (Class clazz : AbstractDb.this.tables.keySet()) {
                                ((AbstractTable)AbstractDb.this.tables.get(clazz)).onDowngradle(sQLiteDatabase, n2, n3);
                            }
                            sQLiteDatabase.setTransactionSuccessful();
                            return;
                        }
                        finally {
                            sQLiteDatabase.endTransaction();
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return;
                    }
                }
            };
            this.initCache();
        }
    }

    private void initCache() {
        for (Class<? extends AbstractTable> clazz : this.tables.keySet()) {
            try {
                this.tables.get(clazz).initCache();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    static interface TableConsumer {
        public void accept(AbstractTable var1);
    }
}

