/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaType {
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final Pattern TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    private static final Pattern PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    private final String mediaType;
    private final String type;
    private final String subtype;
    private final String charset;

    private MediaType(String string, String string2, String string3, String string4) {
        this.mediaType = string;
        this.type = string2;
        this.subtype = string3;
        this.charset = string4;
    }

    public static MediaType get(String string) {
        Matcher matcher = TYPE_SUBTYPE.matcher(string);
        if (!matcher.lookingAt()) {
            throw new IllegalArgumentException("No subtype found for: \"" + string + '\"');
        }
        String string2 = matcher.group(1).toLowerCase(Locale.US);
        String string3 = matcher.group(2).toLowerCase(Locale.US);
        String string4 = null;
        Matcher matcher2 = PARAMETER.matcher(string);
        int n2 = matcher.end();
        while (n2 < string.length()) {
            matcher2.region(n2, string.length());
            if (!matcher2.lookingAt()) {
                throw new IllegalArgumentException("Parameter is not formatted correctly: \"" + string.substring(n2) + "\" for: \"" + string + '\"');
            }
            String string5 = matcher2.group(1);
            if (string5 != null && string5.equalsIgnoreCase("charset")) {
                string5 = matcher2.group(2);
                string5 = string5 != null ? (string5.startsWith("'") && string5.endsWith("'") && string5.length() > 2 ? string5.substring(1, string5.length() - 1) : string5) : matcher2.group(3);
                if (string4 != null && !string5.equalsIgnoreCase(string4)) {
                    throw new IllegalArgumentException("Multiple charsets defined: \"" + string4 + "\" and: \"" + string5 + "\" for: \"" + string + '\"');
                }
                string4 = string5;
            }
            n2 = matcher2.end();
        }
        return new MediaType(string, string2, string3, string4);
    }

    public static MediaType parse(String string) {
        try {
            return MediaType.get(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    public Charset charset() {
        return this.charset(Charset.defaultCharset());
    }

    public Charset charset(Charset charset) {
        try {
            if (this.charset != null) {
                return Charset.forName(this.charset);
            }
            return charset;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return charset;
        }
    }

    public String toString() {
        return this.mediaType;
    }

    public boolean equals(Object object) {
        return object instanceof MediaType && ((MediaType)object).mediaType.equals(this.mediaType);
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }
}

