/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import com.getui.gtc.base.http.GtHttpClient;
import com.getui.gtc.base.http.Interceptor;
import com.getui.gtc.base.http.RealInterceptorChain;
import com.getui.gtc.base.http.Request;
import com.getui.gtc.base.http.Response;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;

public class RetryInterceptor
implements Interceptor {
    private final GtHttpClient client;
    private volatile HttpURLConnection connection;
    private volatile boolean canceled;
    private static final int MAX_RETRY_COUNT = 3;

    public RetryInterceptor(GtHttpClient gtHttpClient) {
        this.client = gtHttpClient;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        HttpURLConnection httpURLConnection;
        Request request = chain.request();
        chain = (RealInterceptorChain)chain;
        this.connection = httpURLConnection = (HttpURLConnection)request.url().openConnection();
        int n2 = 0;
        while (true) {
            if (this.canceled) {
                httpURLConnection.disconnect();
                throw new IOException("Canceled");
            }
            try {
                Response response = ((RealInterceptorChain)chain).proceed(request, httpURLConnection);
                httpURLConnection.disconnect();
                return response;
            }
            catch (IOException iOException) {
                if (n2 >= 3 || !this.recover(iOException, httpURLConnection, request)) {
                    throw iOException;
                }
                httpURLConnection.disconnect();
                this.connection = httpURLConnection = (HttpURLConnection)request.url().openConnection();
                ++n2;
                continue;
            }
            break;
        }
    }

    public void cancel() {
        this.canceled = true;
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    private boolean recover(IOException iOException, HttpURLConnection httpURLConnection, Request request) {
        if (!this.client.isRetryOnConnectionFailure()) {
            return false;
        }
        return this.isRecoverable(iOException);
    }

    private boolean isRecoverable(IOException iOException) {
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return iOException instanceof SocketTimeoutException;
        }
        if (iOException instanceof SSLHandshakeException && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        return !(iOException instanceof SSLPeerUnverifiedException);
    }
}

