/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.http;

import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Util {
    public static final Charset UTF_8 = Charset.forName("UTF-8");

    public static int checkDuration(String string, long l2, TimeUnit timeUnit) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(string + " < 0");
        }
        if (timeUnit == null) {
            throw new NullPointerException("unit == null");
        }
        long l3 = timeUnit.toMillis(l2);
        if (l3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(string + " too large.");
        }
        if (l3 == 0L && l2 > 0L) {
            throw new IllegalArgumentException(string + " too small.");
        }
        return (int)l3;
    }

    public static void checkOffsetAndCount(long l2, long l3, long l4) {
        if ((l3 | l4) < 0L || l3 > l2 || l2 - l3 < l4) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static void checkHeaderItem(String string, String string2) {
        char c2;
        int n2;
        if (string == null) {
            throw new NullPointerException("name == null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3; ++n2) {
            c2 = string.charAt(n2);
            if (c2 > ' ' && c2 < '\u007f') continue;
            throw new IllegalArgumentException(String.format(Locale.US, "Unexpected char %#04x at %d in header name: %s", (int)c2, n2, string));
        }
        if (string2 == null) {
            throw new NullPointerException("value for name " + string + " == null");
        }
        n3 = string2.length();
        for (n2 = 0; n2 < n3; ++n2) {
            c2 = string2.charAt(n2);
            if ((c2 > '\u001f' || c2 == '\t') && c2 < '\u007f') continue;
            throw new IllegalArgumentException(String.format(Locale.US, "Unexpected char %#04x at %d in %s value: %s", (int)c2, n2, string, string2));
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {}
        }
    }
}

