/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.os.Process;
import android.text.TextUtils;
import android.util.ArrayMap;
import com.getui.gtc.base.GtcProvider;
import com.getui.gtc.base.publish.Broker;
import com.getui.gtc.base.publish.Subscriber;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CommonUtil {
    private static Boolean isAppDebug;
    private static File externalFilesDir;

    public static Context findAppContext() {
        try {
            Method method = Class.forName("android.app.ActivityThread").getDeclaredMethod("currentApplication", new Class[0]);
            method.setAccessible(true);
            return (Context)method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static boolean isMainProcess(Context object) {
        try {
            if (object == null) {
                object = CommonUtil.findAppContext();
            }
            if (object != null) {
                object = object.getApplicationInfo().processName;
                String string = CommonUtil.getProcessName();
                return object != null && ((String)object).equals(string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public static boolean isMainProcess() {
        return CommonUtil.isMainProcess(GtcProvider.context());
    }

    public static boolean isGtcProcess() {
        return Process.myPid() == GtcProvider.gtcPid();
    }

    public static boolean isMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean isAppForeground() {
        return CommonUtilSubscriber.getInstance().isAppForeground();
    }

    public static boolean isAppDebugEnable() {
        if (GtcProvider.context() == null) {
            return false;
        }
        if (isAppDebug == null) {
            try {
                isAppDebug = (GtcProvider.context().getApplicationInfo().flags & 2) != 0;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return isAppDebug;
    }

    public static File getExternalFilesDir(Context context) {
        if (externalFilesDir == null) {
            if (context == null) {
                context = CommonUtil.findAppContext();
            }
            externalFilesDir = context.getExternalFilesDir(null);
        }
        return externalFilesDir;
    }

    public static PackageInfo getPackageInfoForSelf(Context context) throws PackageManager.NameNotFoundException {
        context = CommonUtilSubscriber.getInstance().getPackageInfoForSelf(context);
        if (context == null) {
            throw new PackageManager.NameNotFoundException();
        }
        return context;
    }

    public static ApplicationInfo getAppInfoForSelf(Context context) throws PackageManager.NameNotFoundException {
        context = CommonUtilSubscriber.getInstance().getAppInfoForSelf(context);
        if (context == null) {
            throw new PackageManager.NameNotFoundException();
        }
        return context;
    }

    public static String getProcessName() {
        String string;
        block4: {
            string = "unknown.process";
            try {
                if (Build.VERSION.SDK_INT >= 28) {
                    string = Application.getProcessName();
                } else {
                    Method method = Class.forName("android.app.ActivityThread").getDeclaredMethod("currentProcessName", new Class[0]);
                    method.setAccessible(true);
                    string = (String)method.invoke(null, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                String string2 = CommonUtil.getProcessNameByPid(Process.myPid());
                if (TextUtils.isEmpty((CharSequence)string2)) break block4;
                string = string2;
            }
        }
        return string;
    }

    /*
     * Loose catch block
     */
    private static String getProcessNameByPid(int n2) {
        String string;
        BufferedReader bufferedReader;
        block12: {
            bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader("/proc/" + n2 + "/cmdline"));
            string = bufferedReader.readLine();
            if (TextUtils.isEmpty((CharSequence)string)) break block12;
            string = string.trim();
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
            }
            catch (Throwable throwable2) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable2;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public static Activity getTopActivity() {
        try {
            HashMap hashMap = Class.forName("android.app.ActivityThread");
            Object object = ((Class)((Object)hashMap)).getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            hashMap = ((Class)((Object)hashMap)).getDeclaredField("mActivities");
            ((Field)((Object)hashMap)).setAccessible(true);
            hashMap = Build.VERSION.SDK_INT < 19 ? (HashMap)((Field)((Object)hashMap)).get(object) : (ArrayMap)((Field)((Object)hashMap)).get(object);
            if (hashMap.size() <= 0) {
                return null;
            }
            hashMap = hashMap.values().iterator();
            while (hashMap.hasNext()) {
                object = hashMap.next();
                Class<?> clazz = object.getClass();
                Field field = clazz.getDeclaredField("paused");
                field.setAccessible(true);
                if (field.getBoolean(object)) continue;
                hashMap = clazz.getDeclaredField("activity");
                ((Field)((Object)hashMap)).setAccessible(true);
                return (Activity)((Field)((Object)hashMap)).get(object);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static void checkRuntimePermission(Context context, String string, boolean bl) throws Throwable {
        if (!CommonUtil.hasPermission(context, string, bl)) {
            throw new IllegalStateException("permission " + string + " not granted");
        }
    }

    public static boolean hasPermission(Context context, String string, boolean bl) {
        boolean bl2;
        try {
            bl2 = context.getPackageManager().checkPermission(string, context.getPackageName()) == 0;
        }
        catch (Throwable throwable) {
            bl2 = bl;
        }
        return bl2;
    }

    static class CommonUtilSubscriber
    implements Subscriber {
        private static final CommonUtilSubscriber INSTANCE = new CommonUtilSubscriber();
        private static String getInstanceMethodName;
        private PackageInfo packageInfo;
        private ApplicationInfo applicationInfo;

        private CommonUtilSubscriber() {
        }

        public static CommonUtilSubscriber getInstance() {
            getInstanceMethodName = Thread.currentThread().getStackTrace()[2].getMethodName();
            return INSTANCE;
        }

        private Bundle createBundle() {
            Bundle bundle = new Bundle();
            bundle.putString("base-0", this.getClass().getName());
            bundle.putString("base-1", getInstanceMethodName);
            return bundle;
        }

        public boolean isAppForeground() {
            try {
                if (CommonUtil.isGtcProcess()) {
                    return GtcProvider.isForeground();
                }
                Bundle bundle = this.createBundle();
                bundle.putString("base-2", "base-1-1-1");
                return Broker.getInstance().subscribe(bundle).getBoolean("base-3");
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        PackageInfo getPackageInfoForSelf(Context context) {
            try {
                if (CommonUtil.isGtcProcess()) {
                    if (this.packageInfo == null) {
                        if (context == null) {
                            context = CommonUtil.findAppContext();
                        }
                        this.packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 79);
                    }
                    return this.packageInfo;
                }
                GtcProvider.setContext(context);
                context = this.createBundle();
                context.putString("base-2", "base-1-2-1");
                return (PackageInfo)Broker.getInstance().subscribe((Bundle)context).getParcelable("base-3");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        ApplicationInfo getAppInfoForSelf(Context context) {
            try {
                if (CommonUtil.isGtcProcess()) {
                    if (this.applicationInfo == null) {
                        if (context == null) {
                            context = CommonUtil.findAppContext();
                        }
                        this.applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                    }
                    return this.applicationInfo;
                }
                GtcProvider.setContext(context);
                context = this.createBundle();
                context.putString("base-2", "base-1-3-1");
                return (ApplicationInfo)Broker.getInstance().subscribe((Bundle)context).getParcelable("base-3");
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void receive(Bundle object, Bundle object2) {
            ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
            try {
                Throwable throwable = (Throwable)object2.getSerializable("base-4");
                if (throwable != null) {
                    arrayList.add(throwable);
                }
                if (TextUtils.isEmpty((CharSequence)(object = object.getString("base-2")))) {
                    throw new RuntimeException("methodName missed");
                }
                int n2 = -1;
                switch (((String)object).hashCode()) {
                    case -1969640451: {
                        if (!((String)object).equals("base-1-1-1")) break;
                        n2 = 0;
                        break;
                    }
                    case -1969639490: {
                        if (!((String)object).equals("base-1-2-1")) break;
                        n2 = 1;
                        break;
                    }
                    case -1969638529: {
                        if (!((String)object).equals("base-1-3-1")) break;
                        n2 = 2;
                        break;
                    }
                }
                switch (n2) {
                    case 0: {
                        boolean bl = this.isAppForeground();
                        object2.putBoolean("base-3", bl);
                        return;
                    }
                    case 1: {
                        object = this.getPackageInfoForSelf(GtcProvider.context());
                        object2.putParcelable("base-3", (Parcelable)object);
                        return;
                    }
                    case 2: {
                        object = this.getAppInfoForSelf(GtcProvider.context());
                        object2.putParcelable("base-3", (Parcelable)object);
                        return;
                    }
                }
                return;
            }
            catch (Throwable throwable) {
                arrayList.add(throwable);
                return;
            }
            finally {
                Iterator iterator = arrayList.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                    }
                    ((Throwable)iterator.next()).printStackTrace();
                }
            }
        }
    }
}

