/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.util.io;

import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private InputStream inputStream;
    private int[] buffer;
    private int bufferCounter = 0;
    private boolean eof = false;

    public Base64InputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null || this.bufferCounter == this.buffer.length) {
            if (this.eof) {
                return -1;
            }
            this.acquire();
            if (this.buffer.length == 0) {
                this.buffer = null;
                return -1;
            }
            this.bufferCounter = 0;
        }
        return this.buffer[this.bufferCounter++];
    }

    private void acquire() throws IOException {
        int n2;
        char[] cArray = new char[4];
        int n3 = 0;
        do {
            if ((n2 = this.inputStream.read()) == -1) {
                if (n3 != 0) {
                    throw new IOException("Bad base64 stream");
                }
                this.buffer = new int[0];
                this.eof = true;
                return;
            }
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(n2 = (int)((char)n2)) != -1 || n2 == 61) {
                cArray[n3++] = n2;
                continue;
            }
            if (n2 == 13 || n2 == 10) continue;
            throw new IOException("Bad base64 stream");
        } while (n3 < 4);
        n2 = 0;
        for (n3 = 0; n3 < 4; ++n3) {
            if (cArray[n3] != '=') {
                if (n2 == 0) continue;
                throw new IOException("Bad base64 stream");
            }
            if (n2 != 0) continue;
            n2 = 1;
        }
        if (cArray[3] == '=') {
            if (this.inputStream.read() != -1) {
                throw new IOException("Bad base64 stream");
            }
            this.eof = true;
            n2 = cArray[2] == '=' ? 1 : 2;
        } else {
            n2 = 3;
        }
        int n4 = 0;
        for (n3 = 0; n3 < 4; ++n3) {
            if (cArray[n3] == '=') continue;
            n4 |= "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(cArray[n3]) << 6 * (3 - n3);
        }
        this.buffer = new int[n2];
        for (n3 = 0; n3 < n2; ++n3) {
            this.buffer[n3] = n4 >>> 8 * (2 - n3) & 0xFF;
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

