/*
 * Decompiled with CFR 0.152.
 */
package com.getui.gtc.base.util.io;

import com.getui.gtc.base.util.io.Base64OutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtils {
    public static final String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    static final char pad = '=';

    public static byte[] readFile(File object) throws IOException {
        FileInputStream fileInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n2;
            fileInputStream = new FileInputStream((File)object);
            byteArrayOutputStream = new ByteArrayOutputStream();
            object = new byte[1024];
            while ((n2 = fileInputStream.read((byte[])object)) != -1) {
                byteArrayOutputStream.write((byte[])object, 0, n2);
            }
            object = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {}
        return object;
    }

    public static void saveToFile(byte[] byArray, File file) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            fileOutputStream = new FileOutputStream(file);
            byArray = new byte[1024];
            while ((n2 = byteArrayInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
        }
        catch (Throwable throwable) {
            IOUtils.safeClose(byteArrayInputStream);
            IOUtils.safeClose(fileOutputStream);
            throw throwable;
        }
        IOUtils.safeClose(byteArrayInputStream);
        IOUtils.safeClose(fileOutputStream);
    }

    public static void saveToFile(InputStream inputStream, File object) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            fileOutputStream = new FileOutputStream((File)object);
            object = new byte[1024];
            while ((n2 = inputStream.read((byte[])object)) != -1) {
                ((OutputStream)fileOutputStream).write((byte[])object, 0, n2);
            }
        }
        catch (Throwable throwable) {
            IOUtils.safeClose(fileOutputStream);
            throw throwable;
        }
        IOUtils.safeClose(fileOutputStream);
    }

    public static void saveToFile(InputStream inputStream, String object) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            int n2;
            fileOutputStream = new FileOutputStream((String)object);
            object = new byte[1024];
            while ((n2 = inputStream.read((byte[])object)) != -1) {
                ((OutputStream)fileOutputStream).write((byte[])object, 0, n2);
            }
        }
        catch (Throwable throwable) {
            IOUtils.safeClose(fileOutputStream);
            throw throwable;
        }
        IOUtils.safeClose(fileOutputStream);
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public static void copy(byte[] object, OutputStream outputStream) throws IOException {
        object = new ByteArrayInputStream((byte[])object);
        try {
            int n2;
            byte[] byArray = new byte[1024];
            while ((n2 = ((InputStream)object).read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
            return;
        }
        catch (IOException iOException) {
            IOUtils.safeClose((Closeable)object);
            throw iOException;
        }
    }

    public static byte[] encode(byte[] object, int n2) throws RuntimeException {
        object = new ByteArrayInputStream((byte[])object);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            IOUtils.encode((InputStream)object, byteArrayOutputStream, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected I/O error", iOException);
        }
        finally {
            IOUtils.safeClose((Closeable)object);
            IOUtils.safeClose(byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void encode(InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        outputStream = new Base64OutputStream(outputStream, n2);
        IOUtils.copy(inputStream, outputStream);
        ((Base64OutputStream)outputStream).commit();
    }

    public static byte[] gzip(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        GZIPOutputStream gZIPOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(byArray);
            gZIPOutputStream.finish();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.safeClose(gZIPOutputStream);
            IOUtils.safeClose(byteArrayOutputStream);
            throw throwable;
        }
        IOUtils.safeClose(gZIPOutputStream);
        IOUtils.safeClose(byteArrayOutputStream);
        return byArray;
    }

    public static byte[] unGzip(byte[] byArray) throws IOException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = null;
        GZIPInputStream gZIPInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n2;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = gZIPInputStream.read()) != -1) {
                byteArrayOutputStream.write(n2);
            }
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            IOUtils.safeClose(gZIPInputStream);
            IOUtils.safeClose(byteArrayOutputStream);
            IOUtils.safeClose(byteArrayInputStream);
            throw throwable;
        }
        IOUtils.safeClose(gZIPInputStream);
        IOUtils.safeClose(byteArrayOutputStream);
        IOUtils.safeClose(byteArrayInputStream);
        return byArray2;
    }
}

