/*
 * Decompiled with CFR 0.152.
 */
package io.codebakery.imagerotate;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ImageRotateModule
extends ReactContextBaseJavaModule {
    private static final List<String> LOCAL_URI_PREFIXES = Arrays.asList("file://", "content://");
    private static final String TEMP_FILE_PREFIX = "ReactNative_rotated_image_";
    private static final int COMPRESS_QUALITY = 90;
    @SuppressLint(value={"InlinedApi"})
    private static final String[] EXIF_ATTRIBUTES = new String[]{"FNumber", "DateTime", "DateTimeDigitized", "ExposureTime", "Flash", "FocalLength", "GPSAltitude", "GPSAltitudeRef", "GPSDateStamp", "GPSLatitude", "GPSLatitudeRef", "GPSLongitude", "GPSLongitudeRef", "GPSProcessingMethod", "GPSTimeStamp", "ImageLength", "ImageWidth", "ISOSpeedRatings", "Make", "Model", "Orientation", "SubSecTime", "SubSecTimeDigitized", "SubSecTimeOriginal", "WhiteBalance"};

    public ImageRotateModule(ReactApplicationContext reactContext) {
        super(reactContext);
        new CleanTask((ReactContext)this.getReactApplicationContext()).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    public String getName() {
        return "ImageRotateModule";
    }

    public Map<String, Object> getConstants() {
        return Collections.emptyMap();
    }

    public void onCatalystInstanceDestroy() {
        new CleanTask((ReactContext)this.getReactApplicationContext()).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    @ReactMethod
    public void rotateImage(String uri, float angle, Callback success, Callback error) {
        if (uri == null || uri.isEmpty()) {
            throw new JSApplicationIllegalArgumentException("Please specify a URI");
        }
        RotateTask rotateTask = new RotateTask((ReactContext)this.getReactApplicationContext(), uri, angle, success, error);
        rotateTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    private static void copyExif(Context context, Uri oldImage, File newFile) throws IOException {
        File oldFile = ImageRotateModule.getFileFromUri(context, oldImage);
        if (oldFile == null) {
            FLog.w((String)"ReactNative", (String)("Couldn't get real path for uri: " + oldImage));
            return;
        }
        ExifInterface oldExif = new ExifInterface(oldFile.getAbsolutePath());
        ExifInterface newExif = new ExifInterface(newFile.getAbsolutePath());
        for (String attribute : EXIF_ATTRIBUTES) {
            String value = oldExif.getAttribute(attribute);
            if (value == null) continue;
            newExif.setAttribute(attribute, value);
        }
        newExif.saveAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static File getFileFromUri(Context context, Uri uri) {
        Cursor cursor;
        if (uri.getScheme().equals("file")) {
            return new File(uri.getPath());
        }
        if (uri.getScheme().equals("content") && (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null)) != null) {
            try {
                String path;
                if (cursor.moveToFirst() && !TextUtils.isEmpty((CharSequence)(path = cursor.getString(0)))) {
                    File file = new File(path);
                    return file;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    private static boolean isLocalUri(String uri) {
        for (String localPrefix : LOCAL_URI_PREFIXES) {
            if (!uri.startsWith(localPrefix)) continue;
            return true;
        }
        return false;
    }

    private static String getFileExtensionForType(@Nullable String mimeType) {
        if ("image/png".equals(mimeType)) {
            return ".png";
        }
        if ("image/webp".equals(mimeType)) {
            return ".webp";
        }
        return ".jpg";
    }

    private static Bitmap.CompressFormat getCompressFormatForType(String type) {
        if ("image/png".equals(type)) {
            return Bitmap.CompressFormat.PNG;
        }
        if ("image/webp".equals(type)) {
            return Bitmap.CompressFormat.WEBP;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeCompressedBitmapToFile(Bitmap rotated, String mimeType, File tempFile) throws IOException {
        try (FileOutputStream out = new FileOutputStream(tempFile);){
            rotated.compress(ImageRotateModule.getCompressFormatForType(mimeType), 90, (OutputStream)out);
        }
    }

    private static File createTempFile(Context context, @Nullable String mimeType) throws IOException {
        File externalCacheDir = context.getExternalCacheDir();
        File internalCacheDir = context.getCacheDir();
        if (externalCacheDir == null && externalCacheDir == null) {
            throw new IOException("No cache directory available");
        }
        File cacheDir = externalCacheDir == null ? internalCacheDir : (internalCacheDir == null ? externalCacheDir : (externalCacheDir.getFreeSpace() > internalCacheDir.getFreeSpace() ? externalCacheDir : internalCacheDir));
        return File.createTempFile(TEMP_FILE_PREFIX, ImageRotateModule.getFileExtensionForType(mimeType), cacheDir);
    }

    private static class RotateTask
    extends GuardedAsyncTask<Void, Void> {
        final Context mContext;
        final String mUri;
        final float mAngle;
        final Callback mSuccess;
        final Callback mError;

        private RotateTask(ReactContext context, String uri, float angle, Callback success, Callback error) {
            super(context);
            this.mContext = context;
            this.mUri = uri;
            this.mAngle = angle;
            this.mSuccess = success;
            this.mError = error;
        }

        private InputStream openBitmapInputStream() throws IOException {
            InputStream stream;
            if (ImageRotateModule.isLocalUri(this.mUri)) {
                stream = this.mContext.getContentResolver().openInputStream(Uri.parse((String)this.mUri));
            } else {
                URLConnection connection = new URL(this.mUri).openConnection();
                stream = connection.getInputStream();
            }
            if (stream == null) {
                throw new IOException("Cannot open bitmap: " + this.mUri);
            }
            return stream;
        }

        protected void doInBackgroundGuarded(Void ... params) {
            try {
                BitmapFactory.Options outOptions = new BitmapFactory.Options();
                Bitmap rotated = this.rotate(outOptions);
                String mimeType = outOptions.outMimeType;
                if (mimeType == null || mimeType.isEmpty()) {
                    throw new IOException("Could not determine MIME type");
                }
                File tempFile = ImageRotateModule.createTempFile(this.mContext, mimeType);
                ImageRotateModule.writeCompressedBitmapToFile(rotated, mimeType, tempFile);
                if (mimeType.equals("image/jpeg")) {
                    ImageRotateModule.copyExif(this.mContext, Uri.parse((String)this.mUri), tempFile);
                }
                this.mSuccess.invoke(new Object[]{Uri.fromFile((File)tempFile).toString()});
            }
            catch (Exception e) {
                this.mError.invoke(new Object[]{e.getMessage()});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Bitmap rotate(BitmapFactory.Options outOptions) throws IOException {
            try (InputStream inputStream = this.openBitmapInputStream();){
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)outOptions);
                if (bitmap == null) {
                    throw new IOException("Cannot decode bitmap: " + this.mUri);
                }
                Matrix rotateMatrix = new Matrix();
                rotateMatrix.postRotate(this.mAngle);
                Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)rotateMatrix, (boolean)true);
                return bitmap2;
            }
        }
    }

    private static class CleanTask
    extends GuardedAsyncTask<Void, Void> {
        private final Context mContext;

        private CleanTask(ReactContext context) {
            super(context);
            this.mContext = context;
        }

        protected void doInBackgroundGuarded(Void ... params) {
            this.cleanDirectory(this.mContext.getCacheDir());
            File externalCacheDir = this.mContext.getExternalCacheDir();
            if (externalCacheDir != null) {
                this.cleanDirectory(externalCacheDir);
            }
        }

        private void cleanDirectory(File directory) {
            File[] toDelete = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.startsWith(ImageRotateModule.TEMP_FILE_PREFIX);
                }
            });
            if (toDelete != null) {
                for (File file : toDelete) {
                    file.delete();
                }
            }
        }
    }
}

