/*
 * Decompiled with CFR 0.152.
 */
package com.benjamin.rnimagetools;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class ImageTools {
    private static final String IMAGE_JPEG = "image/jpeg";
    private static final String IMAGE_PNG = "image/png";
    private static final String SCHEME_DATA = "data";
    private static final String SCHEME_CONTENT = "content";
    private static final String SCHEME_FILE = "file";
    private static final int MAX_AREA = 7680000;

    private static Bitmap resizeImage(Bitmap image, int maxWidth, int maxHeight) {
        Bitmap newImage = null;
        if (image == null) {
            return null;
        }
        if (maxHeight > 0 && maxWidth > 0) {
            float width = image.getWidth();
            float height = image.getHeight();
            float ratio = Math.min((float)maxWidth / width, (float)maxHeight / height);
            int finalWidth = (int)(width * ratio);
            int finalHeight = (int)(height * ratio);
            try {
                newImage = Bitmap.createScaledBitmap((Bitmap)image, (int)finalWidth, (int)finalHeight, (boolean)true);
            }
            catch (OutOfMemoryError e) {
                return null;
            }
        }
        return newImage;
    }

    public static Bitmap rotateImage(Bitmap source, float angle) {
        Bitmap retVal;
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        try {
            retVal = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (OutOfMemoryError e) {
            return null;
        }
        return retVal;
    }

    private static File saveImage(Bitmap bitmap, File saveDirectory, String fileName, Bitmap.CompressFormat compressFormat, int quality) throws IOException {
        if (bitmap == null) {
            throw new IOException("The bitmap couldn't be resized");
        }
        File newFile = new File(saveDirectory, fileName + "." + compressFormat.name());
        if (!newFile.createNewFile()) {
            throw new IOException("The file already exists");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        bitmap.compress(compressFormat, quality, (OutputStream)outputStream);
        byte[] bitmapData = outputStream.toByteArray();
        outputStream.flush();
        outputStream.close();
        FileOutputStream fos = new FileOutputStream(newFile);
        fos.write(bitmapData);
        fos.flush();
        fos.close();
        return newFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getFileFromUri(Context context, Uri uri) {
        File file = new File(uri.getPath());
        if (file.exists()) {
            return file;
        }
        try (Cursor cursor = null;){
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(uri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String realPath = cursor.getString(column_index);
            file = new File(realPath);
        }
        return file;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options) {
        int height = options.outHeight;
        int width = options.outWidth;
        int area = height * width;
        int inSampleSize = 1;
        while (area > 7680000) {
            area /= 4;
            inSampleSize *= 2;
        }
        return inSampleSize;
    }

    private static Bitmap loadBitmap(Context context, Uri imageUri, BitmapFactory.Options options) throws IOException {
        Bitmap sourceImage = null;
        String imageUriScheme = imageUri.getScheme();
        if (imageUriScheme == null || !imageUriScheme.equalsIgnoreCase(SCHEME_CONTENT)) {
            try {
                sourceImage = BitmapFactory.decodeFile((String)imageUri.getPath(), (BitmapFactory.Options)options);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException("Error decoding image file");
            }
        } else {
            ContentResolver cr = context.getContentResolver();
            InputStream input = cr.openInputStream(imageUri);
            if (input != null) {
                sourceImage = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
                input.close();
            }
        }
        return sourceImage;
    }

    private static Bitmap loadBitmapFromFile(Context context, Uri imageUri) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        ImageTools.loadBitmap(context, imageUri, options);
        options.inSampleSize = ImageTools.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return ImageTools.loadBitmap(context, imageUri, options);
    }

    private static Bitmap loadBitmapFromBase64(Uri imageUri) {
        Bitmap sourceImage = null;
        String imagePath = imageUri.getSchemeSpecificPart();
        int commaLocation = imagePath.indexOf(44);
        if (commaLocation != -1) {
            boolean isPng;
            String mimeType = imagePath.substring(0, commaLocation).replace('\\', '/').toLowerCase();
            boolean isJpeg = mimeType.startsWith(IMAGE_JPEG);
            boolean bl = isPng = !isJpeg && mimeType.startsWith(IMAGE_PNG);
            if (isJpeg || isPng) {
                String encodedImage = imagePath.substring(commaLocation + 1);
                byte[] decodedString = Base64.decode((String)encodedImage, (int)0);
                sourceImage = BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length);
            }
        }
        return sourceImage;
    }

    private static Bitmap Bmp2Binary(Bitmap orgPic, int threshold, int frontColor, int backColor) {
        int width = orgPic.getWidth();
        int height = orgPic.getHeight();
        Bitmap binarymap = null;
        binarymap = orgPic.copy(Bitmap.Config.ARGB_8888, true);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int col = binarymap.getPixel(i, j);
                int alpha = col & 0xFF000000;
                int red = (col & 0xFF0000) >> 16;
                int green = (col & 0xFF00) >> 8;
                int blue = col & 0xFF;
                int gray = (int)((double)red * 0.3 + (double)green * 0.59 + (double)blue * 0.11);
                int newColor = 0;
                newColor = gray <= threshold ? frontColor : backColor;
                binarymap.setPixel(i, j, newColor);
            }
        }
        return binarymap;
    }

    public static File createBinaryImage(Context context, Uri imageUri, int type, int threshold, Bitmap.CompressFormat compressFormat, int quality, String strFrontColorRGBA, String strBackColorRGBA) throws IOException {
        Bitmap sourceImage = ImageTools.LoadImage(context, imageUri);
        if (sourceImage == null) {
            throw new IOException("Unable to load source image from path");
        }
        int frontColorB = Integer.parseInt(strFrontColorRGBA.substring(0, 2), 16);
        int frontColorG = Integer.parseInt(strFrontColorRGBA.substring(2, 4), 16);
        int frontColorR = Integer.parseInt(strFrontColorRGBA.substring(4, 6), 16);
        int frontColorA = Integer.parseInt(strFrontColorRGBA.substring(6, 8), 16);
        int frontColor = (frontColorA << 24) + (frontColorR << 16) + (frontColorG << 8) + frontColorB;
        int backColorB = Integer.parseInt(strBackColorRGBA.substring(0, 2), 16);
        int backColorG = Integer.parseInt(strBackColorRGBA.substring(2, 4), 16);
        int backColorR = Integer.parseInt(strBackColorRGBA.substring(4, 6), 16);
        int backColorA = Integer.parseInt(strBackColorRGBA.substring(6, 8), 16);
        int backColor = (backColorA << 24) + (backColorR << 16) + (backColorG << 8) + backColorB;
        Bitmap binaryMap = null;
        switch (type) {
            case 1: {
                binaryMap = ImageTools.Bmp2Binary(sourceImage, threshold, frontColor, backColor);
                break;
            }
            default: {
                throw new IOException("Unsupported type" + String.valueOf(type));
            }
        }
        sourceImage.recycle();
        File path = context.getCacheDir();
        File newFile = ImageTools.saveImage(binaryMap, path, Long.toString(new Date().getTime()), compressFormat, quality);
        binaryMap.recycle();
        return newFile;
    }

    public static Bitmap LoadImage(Context context, Uri imageUri) throws IOException {
        Bitmap sourceImage = null;
        String imageUriScheme = imageUri.getScheme();
        if (imageUriScheme == null || imageUriScheme.equalsIgnoreCase(SCHEME_FILE) || imageUriScheme.equalsIgnoreCase(SCHEME_CONTENT)) {
            sourceImage = ImageTools.loadBitmapFromFile(context, imageUri);
        } else if (imageUriScheme.equalsIgnoreCase(SCHEME_DATA)) {
            sourceImage = ImageTools.loadBitmapFromBase64(imageUri);
        }
        if (sourceImage == null) {
            throw new IOException("Unable to load source image from path");
        }
        return sourceImage;
    }

    public static int[] GetImageRGBAs(Bitmap sourceImage) throws IOException {
        if (sourceImage != null) {
            int width = sourceImage.getWidth();
            int height = sourceImage.getHeight();
            int[] pixels = new int[width * height];
            sourceImage.getPixels(pixels, 0, width, 0, 0, width, height);
            return pixels;
        }
        return new int[1];
    }
}

