/*
 * Decompiled with CFR 0.152.
 */
package com.benjamin.rnimagetools;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.benjamin.rnimagetools.ImageTools;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import java.io.File;
import java.io.IOException;

public class ImageToolsModule
extends ReactContextBaseJavaModule {
    private Context context;

    public ImageToolsModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.context = reactContext;
    }

    public String getName() {
        return "ImageToolsAndroid";
    }

    @ReactMethod
    public void createBinaryImage(String imagePath, int type, int threshold, String compressFormat, int quality, String strFrontColorRGBA, String strBackColorRGBA, Callback successCb, Callback failureCb) {
        try {
            this.createBinaryImageWithExceptions(imagePath, type, threshold, compressFormat, quality, strFrontColorRGBA, strBackColorRGBA, successCb, failureCb);
        }
        catch (IOException e) {
            failureCb.invoke(new Object[]{e.getMessage()});
        }
    }

    private void createBinaryImageWithExceptions(String imagePath, int type, int threshold, String compressFormatString, int quality, String strFrontColorRGBA, String strBackColorRGBA, Callback successCb, Callback failureCb) throws IOException {
        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.valueOf((String)compressFormatString);
        Uri imageUri = Uri.parse((String)imagePath);
        File fImage = ImageTools.createBinaryImage(this.context, imageUri, type, threshold, compressFormat, quality, strFrontColorRGBA, strBackColorRGBA);
        if (fImage.isFile()) {
            WritableMap response = Arguments.createMap();
            response.putString("path", fImage.getAbsolutePath());
            response.putString("uri", Uri.fromFile((File)fImage).toString());
            response.putString("name", fImage.getName());
            response.putDouble("size", (double)fImage.length());
            successCb.invoke(new Object[]{response});
        } else {
            failureCb.invoke(new Object[]{"Error getting Binary image path"});
        }
    }

    @ReactMethod
    public void GetImageRGBAs(String imagePath, Callback successCb, Callback failureCb) {
        try {
            this.GetImageRGBAsWithExceptions(imagePath, successCb, failureCb);
        }
        catch (IOException e) {
            failureCb.invoke(new Object[]{e.getMessage()});
        }
    }

    private void GetImageRGBAsWithExceptions(String imagePath, Callback successCb, Callback failureCb) throws IOException {
        Uri imageUri = Uri.parse((String)imagePath);
        Bitmap sourceImage = ImageTools.LoadImage(this.context, imageUri);
        if (sourceImage != null) {
            WritableMap response = Arguments.createMap();
            response.putInt("width", sourceImage.getWidth());
            response.putInt("height", sourceImage.getHeight());
            WritableArray datas = Arguments.createArray();
            int[] RGBAs = ImageTools.GetImageRGBAs(sourceImage);
            for (int i = 0; i < RGBAs.length; ++i) {
                datas.pushInt(RGBAs[i]);
            }
            response.putArray("data", datas);
            successCb.invoke(new Object[]{response});
        } else {
            failureCb.invoke(new Object[]{"Error getting Binary image path"});
        }
    }
}

