/*
 * Decompiled with CFR 0.152.
 */
package co.tryinhouse.android;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import co.tryinhouse.android.ShortLinkDetector;
import co.tryinhouse.android.TrackingSDK;
import co.tryinhouse.android.models.SDKConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lco/tryinhouse/android/DeepLinkHandler;", "", "trackingSDK", "Lco/tryinhouse/android/TrackingSDK;", "config", "Lco/tryinhouse/android/models/SDKConfig;", "<init>", "(Lco/tryinhouse/android/TrackingSDK;Lco/tryinhouse/android/models/SDKConfig;)V", "handleDeepLink", "", "activity", "Landroid/app/Activity;", "intent", "Landroid/content/Intent;", "client_release"})
public final class DeepLinkHandler {
    @NotNull
    private final TrackingSDK trackingSDK;
    @NotNull
    private final SDKConfig config;

    public DeepLinkHandler(@NotNull TrackingSDK trackingSDK, @NotNull SDKConfig config) {
        Intrinsics.checkNotNullParameter((Object)trackingSDK, (String)"trackingSDK");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.trackingSDK = trackingSDK;
        this.config = config;
    }

    public final void handleDeepLink(@NotNull Activity activity, @NotNull Intent intent) {
        Uri data;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        if (Intrinsics.areEqual((Object)intent.getAction(), (Object)"android.intent.action.VIEW") && (data = intent.getData()) != null) {
            ShortLinkDetector shortLinkDetector = new ShortLinkDetector(this.config.getShortLinkDomain());
            String string = data.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            if (shortLinkDetector.isShortLink(string)) {
                String string2 = data.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String shortLink = string2;
                TrackingSDK.trackShortLinkClick$default(this.trackingSDK, shortLink, data.toString(), null, 4, null);
                TrackingSDK.trackAppOpenFromShortLink$default(this.trackingSDK, shortLink, null, 2, null);
                if (this.config.getEnableDebugLogging()) {
                    Log.d((String)"DeepLinkHandler", (String)("Handled shortlink: " + shortLink));
                }
            }
        }
    }
}

