/*
 * Decompiled with CFR 0.152.
 */
package com.reactlibrary;

import android.content.Context;
import android.os.RemoteException;
import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.android.installreferrer.api.ReferrerDetails;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableNativeMap;

public class RNInstallReferrerModule
extends ReactContextBaseJavaModule {
    private final ReactApplicationContext reactContext;
    InstallReferrerClient mReferrerClient = null;

    public RNInstallReferrerModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return "RNInstallReferrer";
    }

    @ReactMethod
    public void getReferrer(final Promise promise) {
        this.mReferrerClient = InstallReferrerClient.newBuilder((Context)this.reactContext).build();
        this.mReferrerClient.startConnection(new InstallReferrerStateListener(){

            public void onInstallReferrerSetupFinished(int responseCode) {
                WritableNativeMap result = new WritableNativeMap();
                switch (responseCode) {
                    case 0: {
                        try {
                            ReferrerDetails response = RNInstallReferrerModule.this.mReferrerClient.getInstallReferrer();
                            result.putString("installTimestamp", String.valueOf(response.getInstallBeginTimestampSeconds()));
                            result.putString("installReferrer", response.getInstallReferrer());
                            result.putString("clickTimestamp", String.valueOf(response.getReferrerClickTimestampSeconds()));
                            RNInstallReferrerModule.this.mReferrerClient.endConnection();
                        }
                        catch (RemoteException e) {
                            result.putString("error", e.getMessage());
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 2: {
                        result.putString("message", "FEATURE_NOT_SUPPORTED");
                        break;
                    }
                    case 1: {
                        result.putString("message", "SERVICE_UNAVAILABLE");
                        break;
                    }
                    default: {
                        result.putString("message", "UNKNOWN_RESPONSE_CODE: " + responseCode);
                    }
                }
                promise.resolve((Object)result);
            }

            public void onInstallReferrerServiceDisconnected() {
            }
        });
    }
}

