/*
 * Decompiled with CFR 0.152.
 */
package uk.co.workingedge;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.co.workingedge.ILogger;

public class LaunchNavigator {
    public static final String LOG_TAG = "LaunchNavigator";
    public final String NO_APP_FOUND = "No Activity found to handle Intent";
    public final String MAPS_PROTOCOL = "http://maps.google.com/maps?";
    public final String TURN_BY_TURN_PROTOCOL = "google.navigation:";
    public final String GEO = "geo";
    public final String GOOGLE_MAPS = "google_maps";
    public final String CITYMAPPER = "citymapper";
    public final String UBER = "uber";
    public final String WAZE = "waze";
    public final String YANDEX = "yandex";
    public final String SYGIC = "sygic";
    public final String HERE_MAPS = "here_maps";
    public final String MOOVIT = "moovit";
    public final String LYFT = "lyft";
    public final String MAPS_ME = "maps_me";
    public final String CABIFY = "cabify";
    public final String BAIDU = "baidu";
    public final String TAXIS_99 = "taxis_99";
    public final String GAODE = "gaode";
    public final Map<String, String> supportedAppPackages;
    public final Map<String, String> supportedAppNames;
    public final String GEO_URI = "geo:";
    boolean geocodingEnabled;
    PackageManager packageManager;
    Context context;
    OkHttpClient httpClient;
    ILogger logger;
    Map<String, String> availableApps;
    private final String[] navigateParams;
    String googleApiKey;

    public LaunchNavigator(Context context, ILogger logger) throws Exception {
        HashMap<String, String> _supportedAppPackages = new HashMap<String, String>();
        _supportedAppPackages.put("google_maps", "com.google.android.apps.maps");
        _supportedAppPackages.put("citymapper", "com.citymapper.app.release");
        _supportedAppPackages.put("uber", "com.ubercab");
        _supportedAppPackages.put("waze", "com.waze");
        _supportedAppPackages.put("yandex", "ru.yandex.yandexnavi");
        _supportedAppPackages.put("sygic", "com.sygic.aura");
        _supportedAppPackages.put("here_maps", "com.here.app.maps");
        _supportedAppPackages.put("moovit", "com.tranzmate");
        _supportedAppPackages.put("lyft", "me.lyft.android");
        _supportedAppPackages.put("maps_me", "com.mapswithme.maps.pro");
        _supportedAppPackages.put("cabify", "com.cabify.rider");
        _supportedAppPackages.put("baidu", "com.baidu.BaiduMap");
        _supportedAppPackages.put("taxis_99", "com.taxis99");
        _supportedAppPackages.put("gaode", "com.autonavi.minimap");
        this.supportedAppPackages = Collections.unmodifiableMap(_supportedAppPackages);
        HashMap<String, String> _supportedAppNames = new HashMap<String, String>();
        _supportedAppNames.put("google_maps", "Google Maps");
        _supportedAppNames.put("citymapper", "Citymapper");
        _supportedAppNames.put("uber", "Uber");
        _supportedAppNames.put("waze", "Waze");
        _supportedAppNames.put("yandex", "Yandex Navigator");
        _supportedAppNames.put("sygic", "Sygic");
        _supportedAppNames.put("here_maps", "HERE Maps");
        _supportedAppNames.put("moovit", "Moovit");
        _supportedAppNames.put("lyft", "Lyft");
        _supportedAppNames.put("maps_me", "MAPS.ME");
        _supportedAppNames.put("cabify", "Cabify");
        _supportedAppNames.put("baidu", "Baidu Maps");
        _supportedAppNames.put("taxis_99", "99 Taxi");
        _supportedAppNames.put("gaode", "Gaode Maps (Amap)");
        this.supportedAppNames = Collections.unmodifiableMap(_supportedAppNames);
        this.GEO_URI = "geo:";
        this.geocodingEnabled = true;
        this.httpClient = new OkHttpClient();
        this.navigateParams = new String[]{"app", "dType", "dest", "destNickname", "sType", "start", "startNickname", "transportMode", "launchMode", "extras"};
        this.googleApiKey = null;
        this.setLogger(logger);
        this.initialize(context);
    }

    public LaunchNavigator(Context context, ILogger logger, boolean geocodingEnabled) throws Exception {
        HashMap<String, String> _supportedAppPackages = new HashMap<String, String>();
        _supportedAppPackages.put("google_maps", "com.google.android.apps.maps");
        _supportedAppPackages.put("citymapper", "com.citymapper.app.release");
        _supportedAppPackages.put("uber", "com.ubercab");
        _supportedAppPackages.put("waze", "com.waze");
        _supportedAppPackages.put("yandex", "ru.yandex.yandexnavi");
        _supportedAppPackages.put("sygic", "com.sygic.aura");
        _supportedAppPackages.put("here_maps", "com.here.app.maps");
        _supportedAppPackages.put("moovit", "com.tranzmate");
        _supportedAppPackages.put("lyft", "me.lyft.android");
        _supportedAppPackages.put("maps_me", "com.mapswithme.maps.pro");
        _supportedAppPackages.put("cabify", "com.cabify.rider");
        _supportedAppPackages.put("baidu", "com.baidu.BaiduMap");
        _supportedAppPackages.put("taxis_99", "com.taxis99");
        _supportedAppPackages.put("gaode", "com.autonavi.minimap");
        this.supportedAppPackages = Collections.unmodifiableMap(_supportedAppPackages);
        HashMap<String, String> _supportedAppNames = new HashMap<String, String>();
        _supportedAppNames.put("google_maps", "Google Maps");
        _supportedAppNames.put("citymapper", "Citymapper");
        _supportedAppNames.put("uber", "Uber");
        _supportedAppNames.put("waze", "Waze");
        _supportedAppNames.put("yandex", "Yandex Navigator");
        _supportedAppNames.put("sygic", "Sygic");
        _supportedAppNames.put("here_maps", "HERE Maps");
        _supportedAppNames.put("moovit", "Moovit");
        _supportedAppNames.put("lyft", "Lyft");
        _supportedAppNames.put("maps_me", "MAPS.ME");
        _supportedAppNames.put("cabify", "Cabify");
        _supportedAppNames.put("baidu", "Baidu Maps");
        _supportedAppNames.put("taxis_99", "99 Taxi");
        _supportedAppNames.put("gaode", "Gaode Maps (Amap)");
        this.supportedAppNames = Collections.unmodifiableMap(_supportedAppNames);
        this.GEO_URI = "geo:";
        this.geocodingEnabled = true;
        this.httpClient = new OkHttpClient();
        this.navigateParams = new String[]{"app", "dType", "dest", "destNickname", "sType", "start", "startNickname", "transportMode", "launchMode", "extras"};
        this.googleApiKey = null;
        this.geocodingEnabled = geocodingEnabled;
        this.setLogger(logger);
        this.initialize(context);
    }

    public void setGoogleApiKey(String googleApiKey) {
        this.googleApiKey = googleApiKey;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setGeocoding(boolean geocodingEnabled) {
        this.geocodingEnabled = geocodingEnabled;
    }

    public JSONObject getGeoApps() throws JSONException {
        JSONObject apps = new JSONObject();
        for (Map.Entry<String, String> entry : this.availableApps.entrySet()) {
            String appName = entry.getKey();
            String packageName = entry.getValue();
            if (this.supportedAppPackages.containsValue(packageName)) continue;
            apps.put(appName, (Object)packageName);
        }
        return apps;
    }

    public JSONObject getAvailableApps() throws Exception {
        JSONObject apps = new JSONObject();
        for (Map.Entry<String, String> entry : this.supportedAppPackages.entrySet()) {
            String _appName = entry.getKey();
            String _packageName = entry.getValue();
            apps.put(_appName, this.availableApps.containsValue(_packageName));
        }
        for (Map.Entry<String, String> entry : this.availableApps.entrySet()) {
            String _packageName = entry.getValue();
            if (apps.has(_packageName) || this.supportedAppPackages.containsValue(_packageName)) continue;
            apps.put(_packageName, true);
        }
        return apps;
    }

    public boolean isAppAvailable(String appName) {
        if (this.supportedAppPackages.containsKey(appName)) {
            appName = this.supportedAppPackages.get(appName);
        }
        return this.availableApps.containsValue(appName);
    }

    public String navigate(JSONObject params) throws Exception {
        params = this.ensureNavigateKeys(params);
        String navigateArgs = "Called navigate() with params";
        for (String param : this.navigateParams) {
            navigateArgs = navigateArgs + "; " + param + "=" + params.getString(param);
        }
        this.logger.debug(navigateArgs);
        String appName = params.getString("app");
        String launchMode = params.getString("launchMode");
        String error = appName.equals("google_maps") && !launchMode.equals("geo") ? this.launchGoogleMaps(params) : (appName.equals("citymapper") ? this.launchCitymapper(params) : (appName.equals("uber") ? this.launchUber(params) : (appName.equals("waze") ? this.launchWaze(params) : (appName.equals("yandex") ? this.launchYandex(params) : (appName.equals("sygic") ? this.launchSygic(params) : (appName.equals("here_maps") ? this.launchHereMaps(params) : (appName.equals("moovit") ? this.launchMoovit(params) : (appName.equals("lyft") ? this.launchLyft(params) : (appName.equals("maps_me") ? this.launchMapsMe(params) : (appName.equals("cabify") ? this.launchCabify(params) : (appName.equals("baidu") ? this.launchBaidu(params) : (appName.equals("gaode") ? this.launchGaode(params) : (appName.equals("taxis_99") ? this.launch99Taxis(params) : this.launchApp(params))))))))))))));
        return error;
    }

    private void initialize(Context context) throws Exception {
        if (context == null) {
            throw new Exception("LaunchNavigator: null context passed to initialize()");
        }
        this.context = context;
        this.packageManager = context.getPackageManager();
        this.discoverAvailableApps();
    }

    public void discoverAvailableApps() {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"geo:"));
        List resolveInfoList = this.packageManager.queryIntentActivities(intent, 0);
        this.availableApps = new HashMap<String, String>();
        for (ResolveInfo resolveInfo : resolveInfoList) {
            String packageName = resolveInfo.activityInfo.packageName;
            String appName = this.getAppName(packageName);
            if (this.supportedAppPackages.containsValue(packageName)) continue;
            this.logger.debug("Found available app supporting geo protocol: " + appName + " (" + packageName + ")");
            this.availableApps.put(appName, packageName);
        }
        for (Map.Entry entry : this.supportedAppPackages.entrySet()) {
            String _appName = (String)entry.getKey();
            String _packageName = (String)entry.getValue();
            if (this.isPackageInstalled(_packageName, this.packageManager)) {
                this.availableApps.put(this.supportedAppNames.get(_appName), _packageName);
                this.logger.debug(_appName + " is available");
                continue;
            }
            this.logger.debug(_appName + " is not available");
        }
    }

    private String launchApp(JSONObject params) throws Exception {
        String extras;
        String appName = params.getString("app");
        String dType = params.getString("dType");
        String dNickName = params.getString("destNickname");
        String logMsg = "Using " + this.getAppDisplayName(appName) + " to navigate to ";
        String destLatLon = null;
        String destName = null;
        if (dType.equals("name")) {
            destName = this.getLocationFromName(params, "dest");
            try {
                destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
            }
            catch (Exception e) {
                return "Unable to geocode destination address to coordinates: " + e.getMessage();
            }
            logMsg = logMsg + destName;
            if (!this.isNull(destLatLon)) {
                logMsg = logMsg + "[" + destLatLon + "]";
            }
        } else {
            destLatLon = this.getLocationFromPos(params, "dest");
            logMsg = logMsg + "[" + destLatLon + "]";
        }
        String dest = !this.isNull(destLatLon) ? destLatLon : destName;
        String uri = "geo:" + destLatLon + "?q=" + dest;
        if (!this.isNull(dNickName)) {
            uri = uri + "(" + dNickName + ")";
            logMsg = logMsg + "(" + dNickName + ")";
        }
        if (!this.isNull(extras = this.parseExtrasToUrl(params))) {
            uri = uri + extras;
            logMsg = logMsg + " - extras=" + extras;
        }
        this.logger.debug(logMsg);
        this.logger.debug("URI: " + uri);
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
        if (!appName.equals("geo")) {
            if (appName.equals("google_maps")) {
                appName = this.supportedAppPackages.get("google_maps");
            }
            intent.setPackage(appName);
        }
        this.invokeIntent(intent);
        return null;
    }

    private String launchGoogleMaps(JSONObject params) throws Exception {
        try {
            String url;
            String start = null;
            String dType = params.getString("dType");
            String destination = dType.equals("pos") ? this.getLocationFromPos(params, "dest") : this.getLocationFromName(params, "dest");
            String sType = params.getString("sType");
            if (sType.equals("pos")) {
                start = this.getLocationFromPos(params, "start");
            } else if (sType.equals("name")) {
                start = this.getLocationFromName(params, "start");
            }
            String transportMode = params.getString("transportMode");
            String launchMode = params.getString("launchMode");
            String logMsg = "Using Google Maps to navigate to " + destination;
            if (launchMode.equals("turn-by-turn")) {
                url = "google.navigation:q=" + destination;
                if (!this.isNull(transportMode)) {
                    logMsg = logMsg + " by transportMode=" + transportMode;
                    url = url + "&mode=" + transportMode;
                }
                logMsg = logMsg + " in turn-by-turn mode";
            } else {
                url = "http://maps.google.com/maps?daddr=" + destination;
                if (!this.isNull(start)) {
                    logMsg = logMsg + " from " + start;
                    url = url + "&saddr=" + start;
                } else {
                    logMsg = logMsg + " from current location";
                }
                logMsg = logMsg + " in maps mode";
            }
            String extras = this.parseExtrasToUrl(params);
            if (!this.isNull(extras)) {
                url = url + extras;
                logMsg = logMsg + " - extras=" + extras;
            }
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            intent.setClassName(this.supportedAppPackages.get("google_maps"), "com.google.android.maps.MapsActivity");
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Google Maps app is not installed on this device";
            }
            this.logger.error("Exception occurred: ".concat(msg));
            return msg;
        }
    }

    private String launchCitymapper(JSONObject params) throws Exception {
        try {
            String extras;
            String destAddress = null;
            String destLatLon = null;
            String startAddress = null;
            String startLatLon = null;
            String destNickname = params.getString("destNickname");
            String startNickname = params.getString("startNickname");
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            if (dType.equals("name")) {
                destAddress = this.getLocationFromName(params, "dest");
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            if (sType.equals("name")) {
                startAddress = this.getLocationFromName(params, "start");
            } else if (sType.equals("pos")) {
                startLatLon = this.getLocationFromPos(params, "start");
            }
            String url = "https://citymapper.com/directions?";
            String logMsg = "Using Citymapper to navigate to";
            if (!this.isNull(destAddress)) {
                url = url + "&endaddress=" + Uri.encode((String)destAddress);
                logMsg = logMsg + " '" + destAddress + "'";
            }
            if (this.isNull(destLatLon)) {
                try {
                    destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
                }
                catch (Exception e) {
                    return "Unable to geocode destination address to coordinates: " + e.getMessage();
                }
            }
            url = url + "&endcoord=" + destLatLon;
            logMsg = logMsg + " [" + destLatLon + "]";
            if (!this.isNull(destNickname)) {
                url = url + "&endname=" + Uri.encode((String)destNickname);
                logMsg = logMsg + " (" + destNickname + ")";
            }
            if (!sType.equals("none")) {
                logMsg = logMsg + " from";
                if (!this.isNull(startAddress)) {
                    url = url + "&startaddress=" + Uri.encode((String)startAddress);
                    logMsg = logMsg + " '" + startAddress + "'";
                }
                if (this.isNull(startLatLon)) {
                    try {
                        startLatLon = this.geocodeAddressToLatLon(params.getString("start"));
                    }
                    catch (Exception e) {
                        return "Unable to geocode start address to coordinates: " + e.getMessage();
                    }
                }
                url = url + "&startcoord=" + startLatLon;
                logMsg = logMsg + " [" + startLatLon + "]";
                if (!this.isNull(startNickname)) {
                    url = url + "&startname=" + Uri.encode((String)startNickname);
                    logMsg = logMsg + " (" + startNickname + ")";
                }
            }
            if (!this.isNull(extras = this.parseExtrasToUrl(params))) {
                url = url + extras;
                logMsg = logMsg + " - extras=" + extras;
            }
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Citymapper app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchUber(JSONObject params) throws Exception {
        try {
            String extras;
            String[] parts;
            String destAddress = null;
            String destLatLon = null;
            String startAddress = null;
            String startLatLon = null;
            String destNickname = params.getString("destNickname");
            String startNickname = params.getString("startNickname");
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            if (dType.equals("name")) {
                destAddress = this.getLocationFromName(params, "dest");
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            if (sType.equals("name")) {
                startAddress = this.getLocationFromName(params, "start");
            } else if (sType.equals("pos")) {
                startLatLon = this.getLocationFromPos(params, "start");
            }
            String url = "uber://?action=setPickup";
            String logMsg = "Using Uber to navigate to";
            if (!this.isNull(destAddress)) {
                url = url + "&dropoff[formatted_address]=" + destAddress;
                logMsg = logMsg + " '" + destAddress + "'";
            }
            if (!this.isNull(destLatLon)) {
                parts = this.splitLatLon(destLatLon);
                url = url + "&dropoff[latitude]=" + parts[0] + "&dropoff[longitude]=" + parts[1];
                logMsg = logMsg + " [" + destLatLon + "]";
            }
            if (!this.isNull(destNickname)) {
                url = url + "&dropoff[nickname]=" + destNickname;
                logMsg = logMsg + " (" + destNickname + ")";
            }
            logMsg = logMsg + " from";
            if (!sType.equals("none")) {
                if (!this.isNull(startAddress)) {
                    url = url + "&pickup[formatted_address]==" + startAddress;
                    logMsg = logMsg + " '" + startAddress + "'";
                }
                if (!this.isNull(startLatLon)) {
                    parts = this.splitLatLon(startLatLon);
                    url = url + "&pickup[latitude]=" + parts[0] + "&pickup[longitude]=" + parts[1];
                    logMsg = logMsg + " [" + startLatLon + "]";
                }
                if (!this.isNull(startNickname)) {
                    url = url + "&pickup[nickname]=" + startNickname;
                    logMsg = logMsg + " (" + startNickname + ")";
                }
            } else {
                url = url + "&pickup=my_location";
                logMsg = logMsg + " current location";
            }
            if (!this.isNull(extras = this.parseExtrasToUrl(params))) {
                url = url + extras;
                logMsg = logMsg + " - extras=" + extras;
            }
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Uber app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchWaze(JSONObject params) throws Exception {
        try {
            String destAddress = null;
            String destLatLon = null;
            String dType = params.getString("dType");
            if (dType.equals("name")) {
                destAddress = this.getLocationFromName(params, "dest");
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            String url = "waze://?";
            String logMsg = "Using Waze to navigate to";
            if (!this.isNull(destLatLon)) {
                url = url + "ll=" + destLatLon;
                logMsg = logMsg + " [" + destLatLon + "]";
            } else {
                url = url + "q=" + destAddress;
                logMsg = logMsg + " '" + destAddress + "'";
            }
            url = url + "&navigate=yes";
            logMsg = logMsg + " from current location";
            String extras = this.parseExtrasToUrl(params);
            if (!this.isNull(extras)) {
                url = url + extras;
                logMsg = logMsg + " - extras=" + extras;
            }
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Waze app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchYandex(JSONObject params) throws Exception {
        try {
            String destAddress = null;
            String destLatLon = null;
            String startAddress = null;
            String startLatLon = null;
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            if (dType.equals("name")) {
                destAddress = this.getLocationFromName(params, "dest");
                try {
                    destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
                }
                catch (Exception e) {
                    return "Unable to geocode destination address to coordinates: " + e.getMessage();
                }
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            if (sType.equals("name")) {
                startAddress = this.getLocationFromName(params, "start");
                try {
                    startLatLon = this.geocodeAddressToLatLon(params.getString("start"));
                }
                catch (Exception e) {
                    return "Unable to geocode start address to coordinates: " + e.getMessage();
                }
            } else if (sType.equals("pos")) {
                startLatLon = this.getLocationFromPos(params, "start");
            }
            Intent intent = new Intent(this.supportedAppPackages.get("yandex") + ".action.BUILD_ROUTE_ON_MAP");
            intent.setPackage(this.supportedAppPackages.get("yandex"));
            String logMsg = "Using Yandex to navigate to";
            String[] parts = this.splitLatLon(destLatLon);
            intent.putExtra("lat_to", parts[0]);
            intent.putExtra("lon_to", parts[1]);
            logMsg = logMsg + " [" + destLatLon + "]";
            if (!this.isNull(destAddress)) {
                logMsg = logMsg + " ('" + destAddress + "')";
            }
            logMsg = logMsg + " from";
            if (!sType.equals("none")) {
                parts = this.splitLatLon(startLatLon);
                intent.putExtra("lat_from", parts[0]);
                intent.putExtra("lon_from", parts[1]);
                logMsg = logMsg + " [" + startLatLon + "]";
                if (!this.isNull(startAddress)) {
                    logMsg = logMsg + " ('" + startAddress + "')";
                }
            } else {
                logMsg = logMsg + " current location";
            }
            String jsonStringExtras = params.getString("extras");
            JSONObject oExtras = null;
            if (!this.isNull(jsonStringExtras)) {
                oExtras = new JSONObject(jsonStringExtras);
            }
            if (oExtras != null) {
                Iterator keys = oExtras.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = oExtras.getString(key);
                    intent.putExtra(key, value);
                }
            }
            this.logger.debug(logMsg);
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Yandex app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchSygic(JSONObject params) throws Exception {
        try {
            String destAddress = null;
            String destLatLon = null;
            String dType = params.getString("dType");
            String transportMode = params.getString("transportMode");
            String url = this.supportedAppPackages.get("sygic") + "://coordinate|";
            String logMsg = "Using Sygic to navigate to";
            transportMode = transportMode.equals("w") ? "walk" : "drive";
            if (dType.equals("name")) {
                destAddress = this.getLocationFromName(params, "dest");
                logMsg = logMsg + " '" + destAddress + "'";
                try {
                    destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
                }
                catch (Exception e) {
                    return "Unable to geocode destination address to coordinates: " + e.getMessage();
                }
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            logMsg = logMsg + " [" + destLatLon + "]";
            String[] pos = this.splitLatLon(destLatLon);
            url = url + pos[1] + "|" + pos[0] + "|" + transportMode;
            logMsg = logMsg + " by " + transportMode;
            String extras = this.parseExtrasToUrl(params);
            if (!this.isNull(extras)) {
                url = url + extras;
                logMsg = logMsg + " - extras=" + extras;
            }
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Sygic app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchHereMaps(JSONObject params) throws Exception {
        try {
            String extras;
            String destLatLon = null;
            String startLatLon = null;
            String destNickname = params.getString("destNickname");
            String startNickname = params.getString("startNickname");
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            String url = "https://share.here.com/r/";
            String logMsg = "Using HERE Maps to navigate";
            logMsg = logMsg + " from";
            if (sType.equals("none")) {
                url = url + "mylocation";
                logMsg = logMsg + " Current Location";
            } else {
                if (sType.equals("name")) {
                    String startAddress = this.getLocationFromName(params, "start");
                    logMsg = logMsg + " '" + startAddress + "'";
                    try {
                        startLatLon = this.geocodeAddressToLatLon(params.getString("start"));
                    }
                    catch (Exception e) {
                        return "Unable to geocode start address to coordinates: " + e.getMessage();
                    }
                } else if (sType.equals("pos")) {
                    startLatLon = this.getLocationFromPos(params, "start");
                }
                url = url + startLatLon;
                logMsg = logMsg + " [" + startLatLon + "]";
                if (!this.isNull(startNickname)) {
                    url = url + "," + startNickname;
                    logMsg = logMsg + " (" + startNickname + ")";
                }
            }
            url = url + "/";
            logMsg = logMsg + " to";
            if (dType.equals("name")) {
                String destAddress = this.getLocationFromName(params, "dest");
                logMsg = logMsg + " '" + destAddress + "'";
                try {
                    destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
                }
                catch (Exception e) {
                    return "Unable to geocode destination address to coordinates: " + e.getMessage();
                }
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            logMsg = logMsg + " [" + destLatLon + "]";
            url = url + destLatLon;
            if (!this.isNull(destNickname)) {
                url = url + "," + destNickname;
                logMsg = logMsg + " (" + destNickname + ")";
            }
            if (!this.isNull(extras = this.parseExtrasToUrl(params))) {
                url = url + "?" + extras;
                logMsg = logMsg + " - extras=" + extras;
            }
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "HERE Maps app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchMoovit(JSONObject params) throws Exception {
        try {
            String destLatLon = null;
            String startLatLon = null;
            String destNickname = params.getString("destNickname");
            String startNickname = params.getString("startNickname");
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            String url = "moovit://directions";
            String logMsg = "Using Moovit to navigate";
            logMsg = logMsg + " to";
            if (dType.equals("name")) {
                String destAddress = this.getLocationFromName(params, "dest");
                logMsg = logMsg + " '" + destAddress + "'";
                try {
                    destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
                }
                catch (Exception e) {
                    return "Unable to geocode destination address to coordinates: " + e.getMessage();
                }
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            logMsg = logMsg + " [" + destLatLon + "]";
            String[] destPos = this.splitLatLon(destLatLon);
            url = url + "?dest_lat=" + destPos[0] + "&dest_lon=" + destPos[1];
            if (!this.isNull(destNickname)) {
                url = url + "&dest_name=" + destNickname;
                logMsg = logMsg + " (" + destNickname + ")";
            }
            logMsg = logMsg + " from";
            if (sType.equals("none")) {
                logMsg = logMsg + " Current Location";
            } else {
                if (sType.equals("name")) {
                    String startAddress = this.getLocationFromName(params, "start");
                    logMsg = logMsg + " '" + startAddress + "'";
                    try {
                        startLatLon = this.geocodeAddressToLatLon(params.getString("start"));
                    }
                    catch (Exception e) {
                        return "Unable to geocode start address to coordinates: " + e.getMessage();
                    }
                } else if (sType.equals("pos")) {
                    startLatLon = this.getLocationFromPos(params, "start");
                }
                String[] startPos = this.splitLatLon(startLatLon);
                url = url + "&orig_lat=" + startPos[0] + "&orig_lon=" + startPos[1];
                logMsg = logMsg + " [" + startLatLon + "]";
                if (!this.isNull(startNickname)) {
                    url = url + "&orig_name=" + startNickname;
                    logMsg = logMsg + " (" + startNickname + ")";
                }
            }
            String extras = this.parseExtrasToUrl(params);
            if (!this.isNull(extras)) {
                url = url + extras;
                logMsg = logMsg + " - extras=" + extras;
            }
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Moovit app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchLyft(JSONObject params) throws Exception {
        try {
            String destLatLon = null;
            String startLatLon = null;
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            String url = "lyft://ridetype?";
            String logMsg = "Using Lyft to navigate";
            String extras = this.parseExtrasToUrl(params);
            if (!this.isNull(extras)) {
                url = url + extras;
                logMsg = logMsg + " - extras=" + extras;
            }
            if (this.isNull(extras) || !extras.contains("id=")) {
                url = url + "id=lyft";
            }
            logMsg = logMsg + " to";
            if (dType.equals("name")) {
                String destAddress = this.getLocationFromName(params, "dest");
                logMsg = logMsg + " '" + destAddress + "'";
                try {
                    destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
                }
                catch (Exception e) {
                    return "Unable to geocode destination address to coordinates: " + e.getMessage();
                }
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            logMsg = logMsg + " [" + destLatLon + "]";
            String[] destPos = this.splitLatLon(destLatLon);
            url = url + "&destination[latitude]=" + destPos[0] + "&destination[longitude]=" + destPos[1];
            logMsg = logMsg + " from";
            if (sType.equals("none")) {
                logMsg = logMsg + " Current Location";
            } else {
                if (sType.equals("name")) {
                    String startAddress = this.getLocationFromName(params, "start");
                    logMsg = logMsg + " '" + startAddress + "'";
                    try {
                        startLatLon = this.geocodeAddressToLatLon(params.getString("start"));
                    }
                    catch (Exception e) {
                        return "Unable to geocode start address to coordinates: " + e.getMessage();
                    }
                } else if (sType.equals("pos")) {
                    startLatLon = this.getLocationFromPos(params, "start");
                }
                String[] startPos = this.splitLatLon(startLatLon);
                url = url + "&pickup[latitude]=" + startPos[0] + "&pickup[longitude]=" + startPos[1];
                logMsg = logMsg + " [" + startLatLon + "]";
            }
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Lyft app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchMapsMe(JSONObject params) throws Exception {
        try {
            String destLatLon = null;
            String startLatLon = null;
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            String transportMode = params.getString("transportMode");
            Intent intent = new Intent(this.supportedAppPackages.get("maps_me").concat(".action.BUILD_ROUTE"));
            intent.setPackage(this.supportedAppPackages.get("maps_me"));
            String logMsg = "Using MAPs.ME to navigate";
            logMsg = logMsg + " to";
            if (dType.equals("name")) {
                String destAddress = this.getLocationFromName(params, "dest");
                logMsg = logMsg + " '" + destAddress + "'";
                try {
                    destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
                }
                catch (Exception e) {
                    return "Unable to geocode destination address to coordinates: " + e.getMessage();
                }
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            logMsg = logMsg + " [" + destLatLon + "]";
            String[] destPos = this.splitLatLon(destLatLon);
            intent.putExtra("lat_to", Double.parseDouble(destPos[0]));
            intent.putExtra("lon_to", Double.parseDouble(destPos[1]));
            logMsg = logMsg + " from";
            if (sType.equals("none")) {
                logMsg = logMsg + " Current Location";
            } else {
                if (sType.equals("name")) {
                    String startAddress = this.getLocationFromName(params, "start");
                    logMsg = logMsg + " '" + startAddress + "'";
                    try {
                        startLatLon = this.geocodeAddressToLatLon(params.getString("start"));
                    }
                    catch (Exception e) {
                        return "Unable to geocode start address to coordinates: " + e.getMessage();
                    }
                } else if (sType.equals("pos")) {
                    startLatLon = this.getLocationFromPos(params, "start");
                }
                String[] startPos = this.splitLatLon(startLatLon);
                intent.putExtra("lat_from", Double.parseDouble(startPos[0]));
                intent.putExtra("lon_from", Double.parseDouble(startPos[1]));
                logMsg = logMsg + " [" + startLatLon + "]";
            }
            if (transportMode.equals("d")) {
                transportMode = "vehicle";
            } else if (transportMode.equals("w")) {
                transportMode = "pedestrian";
            } else if (transportMode.equals("b")) {
                transportMode = "bicycle";
            } else if (transportMode.equals("t")) {
                transportMode = "taxi";
            }
            if (!this.isNull(transportMode)) {
                intent.putExtra("router", transportMode);
                logMsg = logMsg + " by transportMode=" + transportMode;
            }
            this.logger.debug(logMsg);
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "MAPS.ME app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchCabify(JSONObject params) throws Exception {
        try {
            String extras;
            String destLatLon = null;
            String startLatLon = null;
            String destNickname = params.getString("destNickname");
            String startNickname = params.getString("startNickname");
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            String url = "cabify://cabify/journey?json=";
            String logMsg = "Using Cabify to navigate";
            JSONObject oJson = new JSONObject();
            JSONObject oDest = new JSONObject();
            logMsg = logMsg + " to";
            if (dType.equals("name")) {
                String destAddress = this.getLocationFromName(params, "dest");
                logMsg = logMsg + " '" + destAddress + "'";
                try {
                    destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
                }
                catch (Exception e) {
                    return "Unable to geocode destination address to coordinates: " + e.getMessage();
                }
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            logMsg = logMsg + " [" + destLatLon + "]";
            String[] destPos = this.splitLatLon(destLatLon);
            JSONObject oDestLoc = new JSONObject();
            oDestLoc.put("latitude", (Object)destPos[0]);
            oDestLoc.put("longitude", (Object)destPos[1]);
            oDest.put("loc", (Object)oDestLoc);
            if (!this.isNull(destNickname)) {
                oDest.put("name", (Object)destNickname);
                logMsg = logMsg + " (" + destNickname + ")";
            }
            JSONObject oStart = new JSONObject();
            logMsg = logMsg + " from";
            if (sType.equals("none")) {
                logMsg = logMsg + " Current Location";
                oStart.put("loc", (Object)"current");
            } else {
                if (sType.equals("name")) {
                    String startAddress = this.getLocationFromName(params, "start");
                    logMsg = logMsg + " '" + startAddress + "'";
                    try {
                        startLatLon = this.geocodeAddressToLatLon(params.getString("start"));
                    }
                    catch (Exception e) {
                        return "Unable to geocode start address to coordinates: " + e.getMessage();
                    }
                } else if (sType.equals("pos")) {
                    startLatLon = this.getLocationFromPos(params, "start");
                }
                logMsg = logMsg + " [" + startLatLon + "]";
                String[] startPos = this.splitLatLon(startLatLon);
                JSONObject oStartLoc = new JSONObject();
                oStartLoc.put("latitude", (Object)startPos[0]);
                oStartLoc.put("longitude", (Object)startPos[1]);
                oStart.put("loc", (Object)oStartLoc);
            }
            if (!this.isNull(startNickname)) {
                oStart.put("name", (Object)startNickname);
                logMsg = logMsg + " (" + startNickname + ")";
            }
            if (!this.isNull(extras = params.getString("extras"))) {
                oJson = new JSONObject(extras);
                logMsg = logMsg + " - extras=" + extras;
            }
            JSONArray aStops = new JSONArray();
            aStops.put((Object)oStart);
            if (oJson.has("stops")) {
                JSONArray stops = oJson.getJSONArray("stops");
                for (int i = 0; i < stops.length(); ++i) {
                    aStops.put((Object)stops.getJSONObject(i));
                }
            }
            aStops.put((Object)oDest);
            oJson.put("stops", (Object)aStops);
            url = url + oJson.toString();
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Cabify app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchBaidu(JSONObject params) throws Exception {
        try {
            String dest;
            String destNickname = params.getString("destNickname");
            String startNickname = params.getString("startNickname");
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            String transportMode = params.getString("transportMode");
            String url = "baidumap://map/direction";
            String logMsg = "Using Baidu Maps to navigate";
            String extras = this.parseExtrasToUrl(params);
            if (this.isNull(extras)) {
                extras = "";
            }
            if (!extras.contains("coord_type=")) {
                extras = extras + "&coord_type=wgs84";
            }
            logMsg = logMsg + " to";
            if (dType.equals("name")) {
                dest = this.getLocationFromName(params, "dest");
                logMsg = logMsg + dest;
            } else {
                dest = this.getLocationFromPos(params, "dest");
                logMsg = logMsg + " [" + dest + "]";
                if (!this.isNull(destNickname)) {
                    dest = "latlng:" + dest + "|name:" + destNickname;
                    logMsg = logMsg + " (" + destNickname + ")";
                }
            }
            url = url + "?destination=" + dest;
            logMsg = logMsg + " from";
            if (sType.equals("none")) {
                logMsg = logMsg + " Current Location";
            } else {
                String start;
                if (sType.equals("name")) {
                    start = this.getLocationFromName(params, "start");
                    logMsg = logMsg + start;
                } else {
                    start = this.getLocationFromPos(params, "start");
                    logMsg = logMsg + " [" + start + "]";
                    if (!this.isNull(startNickname)) {
                        start = "latlng:" + start + "|name:" + startNickname;
                        logMsg = logMsg + " (" + startNickname + ")";
                    }
                }
                url = url + "&origin=" + start;
            }
            transportMode = transportMode.equals("d") ? "driving" : (transportMode.equals("w") ? "walking" : (transportMode.equals("b") ? "riding" : (transportMode.equals("t") ? "transit" : "driving")));
            url = url + "&mode=" + transportMode;
            logMsg = logMsg + " by transportMode=" + transportMode;
            url = url + extras;
            logMsg = logMsg + " - extras=" + extras;
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent();
            intent.setData(Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Baidu Maps app is not installed on this device";
            }
            return msg;
        }
    }

    private String launchGaode(JSONObject params) throws Exception {
        try {
            String transportModeName;
            String destAddress = null;
            String destLatLon = null;
            String startAddress = null;
            String startLatLon = null;
            String destNickname = params.getString("destNickname");
            String startNickname = params.getString("startNickname");
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            String transportMode = params.getString("transportMode");
            String url = "amapuri://route/plan/?";
            String logMsg = "Using Gaode Maps to navigate";
            String extras = this.parseExtrasToUrl(params);
            if (this.isNull(extras)) {
                extras = "";
            }
            if (!extras.contains("sourceApplication=")) {
                extras = extras + "&sourceApplication=" + Uri.encode((String)this.getThisAppName());
            }
            logMsg = logMsg + " to";
            if (dType.equals("name")) {
                destAddress = this.getLocationFromName(params, "dest");
                logMsg = logMsg + " '" + destAddress + "'";
                try {
                    destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
                }
                catch (Exception e) {
                    return "Unable to geocode destination address to coordinates: " + e.getMessage();
                }
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            logMsg = logMsg + " [" + destLatLon + "]";
            String[] pos = this.splitLatLon(destLatLon);
            url = url + "dlat=" + pos[0] + "&dlon=" + pos[1];
            if (!this.isNull(destNickname)) {
                logMsg = logMsg + " (" + destNickname + ")";
                url = url + "&dname=" + destNickname;
            }
            logMsg = logMsg + " from";
            if (sType.equals("none")) {
                logMsg = logMsg + " Current Location";
            } else {
                if (sType.equals("name")) {
                    startAddress = this.getLocationFromName(params, "start");
                    logMsg = logMsg + " '" + startAddress + "'";
                    try {
                        startLatLon = this.geocodeAddressToLatLon(params.getString("start"));
                    }
                    catch (Exception e) {
                        startLatLon = null;
                    }
                } else {
                    startLatLon = this.getLocationFromPos(params, "start");
                }
                if (!this.isNull(startLatLon)) {
                    logMsg = logMsg + " [" + startLatLon + "]";
                    pos = this.splitLatLon(startLatLon);
                    url = url + "&slat=" + pos[0] + "&slon=" + pos[1];
                    if (!this.isNull(startNickname)) {
                        logMsg = logMsg + " (" + startNickname + ")";
                        url = url + "&sname=" + startNickname;
                    }
                }
            }
            if (transportMode.equals("d")) {
                transportModeName = "driving";
                transportMode = "0";
            } else if (transportMode.equals("w")) {
                transportModeName = "walking";
                transportMode = "2";
            } else if (transportMode.equals("b")) {
                transportModeName = "bicycle";
                transportMode = "3";
            } else if (transportMode.equals("t")) {
                transportModeName = "transit";
                transportMode = "1";
            } else {
                transportModeName = "driving";
                transportMode = "0";
            }
            url = url + "&t=" + transportMode;
            logMsg = logMsg + " by transportMode=" + transportModeName;
            url = url + extras;
            logMsg = logMsg + " - extras=" + extras;
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent();
            intent.setData(Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "Gaode Maps app is not installed on this device";
            }
            return msg;
        }
    }

    private String launch99Taxis(JSONObject params) throws Exception {
        try {
            String destAddress = null;
            String destLatLon = null;
            String startAddress = null;
            String startLatLon = null;
            String destNickname = params.getString("destNickname");
            String startNickname = params.getString("startNickname");
            String dType = params.getString("dType");
            String sType = params.getString("sType");
            String url = "taxis99://call?";
            String logMsg = "Using 99 Taxi to navigate";
            String extras = this.parseExtrasToUrl(params);
            if (this.isNull(extras)) {
                extras = "";
            }
            if (!extras.contains("deep_link_product_id")) {
                extras = extras + "&deep_link_product_id=316";
            }
            if (!extras.contains("client_id")) {
                extras = extras + "&client_id=MAP_123";
            }
            logMsg = logMsg + " to";
            if (dType.equals("name")) {
                destAddress = this.getLocationFromName(params, "dest");
                logMsg = logMsg + " '" + destAddress + "'";
                try {
                    destLatLon = this.geocodeAddressToLatLon(params.getString("dest"));
                }
                catch (Exception e) {
                    return "Unable to geocode destination address to coordinates: " + e.getMessage();
                }
            } else {
                destLatLon = this.getLocationFromPos(params, "dest");
            }
            logMsg = logMsg + " [" + destLatLon + "]";
            String[] pos = this.splitLatLon(destLatLon);
            url = url + "dropoff_latitude=" + pos[0] + "&dropoff_longitude=" + pos[1];
            if (this.isNull(destNickname)) {
                destNickname = !this.isNull(destAddress) ? destAddress : "Dropoff";
            }
            logMsg = logMsg + " (" + destNickname + ")";
            url = url + "&dropoff_title=" + destNickname;
            logMsg = logMsg + " from";
            if (sType.equals("name")) {
                startAddress = this.getLocationFromName(params, "start");
                logMsg = logMsg + " '" + startAddress + "'";
                try {
                    startLatLon = this.geocodeAddressToLatLon(params.getString("start"));
                }
                catch (Exception e) {
                    return "Unable to geocode start address to coordinates: " + e.getMessage();
                }
            } else if (sType.equals("pos")) {
                startLatLon = this.getLocationFromPos(params, "start");
            } else {
                return "start location is a required parameter for 99 Taxi and must be specified";
            }
            logMsg = logMsg + " [" + startLatLon + "]";
            pos = this.splitLatLon(startLatLon);
            url = url + "&pickup_latitude=" + pos[0] + "&pickup_longitude=" + pos[1];
            if (this.isNull(startNickname)) {
                startNickname = !this.isNull(startAddress) ? startAddress : "Pickup";
            }
            logMsg = logMsg + " (" + startNickname + ")";
            url = url + "&pickup_title=" + startNickname;
            url = url + extras;
            logMsg = logMsg + " - extras=" + extras;
            this.logger.debug(logMsg);
            this.logger.debug("URI: " + url);
            Intent intent = new Intent();
            intent.setData(Uri.parse((String)url));
            this.invokeIntent(intent);
            return null;
        }
        catch (JSONException e) {
            String msg = e.getMessage();
            if (msg.contains("No Activity found to handle Intent")) {
                msg = "99 Taxis app is not installed on this device";
            }
            return msg;
        }
    }

    private void invokeIntent(Intent intent) {
        intent.addFlags(0x10000000);
        this.context.startActivity(intent);
    }

    private String parseExtrasToUrl(JSONObject params) throws JSONException {
        String extras = null;
        String jsonStringExtras = params.getString("extras");
        JSONObject oExtras = null;
        if (!this.isNull(jsonStringExtras)) {
            oExtras = new JSONObject(jsonStringExtras);
        }
        if (oExtras != null) {
            Iterator keys = oExtras.keys();
            extras = "";
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = oExtras.getString(key);
                extras = extras + "&" + key + "=" + value;
            }
        }
        return extras;
    }

    private String getLocationFromPos(JSONObject params, String key) throws Exception {
        JSONArray pos = new JSONArray(params.getString(key));
        String lat = pos.getString(0);
        String lon = pos.getString(1);
        if (this.isNull(lat) || lat.length() == 0 || this.isNull(lon) || lon.length() == 0) {
            throw new Exception("Expected two non-empty string arguments for lat/lon.");
        }
        String location = lat + "," + lon;
        return location;
    }

    private String getLocationFromName(JSONObject params, String key) throws Exception {
        String name = params.getString(key);
        if (this.isNull(name) || name.length() == 0) {
            throw new Exception("Expected non-empty string argument for place name.");
        }
        return name;
    }

    private String[] splitLatLon(String latlon) {
        return latlon.split(",");
    }

    private String getAppName(String packageName) {
        ApplicationInfo ai;
        try {
            ai = this.packageManager.getApplicationInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        String applicationName = (String)(ai != null ? this.packageManager.getApplicationLabel(ai) : null);
        return applicationName;
    }

    private boolean isPackageInstalled(String packagename, PackageManager packageManager) {
        try {
            packageManager.getPackageInfo(packagename, 1);
            ApplicationInfo ai = packageManager.getApplicationInfo(packagename, 0);
            return ai.enabled;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private String geocodeAddressToLatLon(String address) throws Exception {
        String errMsg = "Unable to geocode coords from address '" + address;
        if (!this.geocodingEnabled) {
            throw new Exception("Geocoding disabled: " + errMsg);
        }
        if (!this.isNetworkAvailable()) {
            throw new Exception("No internet connection: " + errMsg);
        }
        address = address.replaceAll(" ", "%20");
        JSONObject oResponse = this.doGeocode("address=" + address);
        double longitude = oResponse.getJSONObject("geometry").getJSONObject("location").getDouble("lng");
        double latitude = oResponse.getJSONObject("geometry").getJSONObject("location").getDouble("lat");
        String result = latitude + "," + longitude;
        this.logger.debug("Geocoded '" + address + "' to '" + result + "'");
        return result;
    }

    private String reverseGeocodeLatLonToAddress(String latLon) throws Exception {
        String errMsg = "Unable to reverse geocode address from coords '" + latLon;
        if (!this.geocodingEnabled) {
            throw new Exception("Geocoding is disabled: " + errMsg);
        }
        if (!this.isNetworkAvailable()) {
            throw new Exception("No internet connection: " + errMsg);
        }
        JSONObject oResponse = this.doGeocode("latlng=" + latLon);
        String result = oResponse.getString("formatted_address");
        this.logger.debug("Reverse geocoded '" + latLon + "' to '" + result + "'");
        return result;
    }

    private JSONObject doGeocode(String query) throws Exception {
        if (this.googleApiKey == null) {
            throw new Exception("Google API key has not been specified");
        }
        String url = "https://maps.google.com/maps/api/geocode/json?" + query + "&sensor=false&key=" + this.googleApiKey;
        Request request = new Request.Builder().url(url).build();
        Response response = this.httpClient.newCall(request).execute();
        String responseBody = response.body().string();
        JSONObject oResponse = new JSONObject(responseBody);
        if (oResponse.has("error_message")) {
            throw new Exception(oResponse.getString("error_message"));
        }
        return ((JSONArray)oResponse.get("results")).getJSONObject(0);
    }

    private boolean isNull(String arg) {
        return arg == null || arg.equals("null");
    }

    private JSONObject ensureNavigateKeys(JSONObject params) throws Exception {
        for (String param : this.navigateParams) {
            if (params.has(param)) continue;
            params.put(param, (Object)"null");
        }
        return params;
    }

    private String getAppDisplayName(String packageName) {
        String name = "[Not found]";
        if (packageName.equals("geo")) {
            return "[Native chooser]";
        }
        for (Map.Entry<String, String> entry : this.availableApps.entrySet()) {
            String _appName = entry.getKey();
            String _packageName = entry.getValue();
            if (!packageName.equals(_packageName)) continue;
            name = _appName;
            break;
        }
        return name;
    }

    private String getThisAppName() {
        return this.context.getApplicationInfo().loadLabel(this.packageManager).toString();
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }
}

