/*
 * Decompiled with CFR 0.152.
 */
package uk.co.workingedge.RNLaunchNavigator;

import android.content.Context;
import android.util.Log;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import uk.co.workingedge.LaunchNavigator;
import uk.co.workingedge.RNLaunchNavigator.RNLogger;
import uk.co.workingedge.RNLaunchNavigator.RNUtils;

public class RNLaunchNavigatorModule
extends ReactContextBaseJavaModule {
    private static final String NATIVE = "[native]";
    private static final String MODULE_NAME = "RNLaunchNavigator";
    private static final String LOG_TAG = "RNLaunchNavigator[native]";
    private static final String ERROR_CODE_EXCEPTION = "EXCEPTION";
    private static final String ERROR_CODE_ERROR = "ERROR";
    private LaunchNavigator launchNavigator = null;
    private RNLogger logger = null;

    public RNLaunchNavigatorModule(ReactApplicationContext reactContext) {
        super(reactContext);
        try {
            this.logger = new RNLogger((ReactContext)reactContext, LOG_TAG);
            this.launchNavigator = new LaunchNavigator((Context)this.getReactApplicationContext(), new RNLogger((ReactContext)reactContext, "LaunchNavigator[native]"));
        }
        catch (Exception e) {
            Log.e((String)MODULE_NAME, (String)("Exception initializing :" + e.getMessage()));
        }
    }

    public String getName() {
        return MODULE_NAME;
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("LOG_TAG", LOG_TAG);
        return constants;
    }

    @ReactMethod
    public void setGoogleApiKey(String googleApiKey) {
        this.launchNavigator.setGoogleApiKey(googleApiKey);
    }

    @ReactMethod
    public void enableDebug(Boolean enabled) {
        this.logger.setEnabled(enabled);
        this.launchNavigator.getLogger().setEnabled(enabled);
    }

    @ReactMethod
    public void getGeoApps(Promise promise) {
        try {
            this.logger.debug("getGeoApps");
            JSONObject oApps = this.launchNavigator.getGeoApps();
            WritableMap mApps = RNUtils.convertJsonToMap(oApps);
            promise.resolve((Object)mApps);
        }
        catch (Exception e) {
            this.handleExceptionWithPromise(promise, e);
        }
    }

    @ReactMethod
    public void getAvailableApps(Promise promise) {
        try {
            this.logger.debug("getAvailableApps");
            this.launchNavigator.discoverAvailableApps();
            JSONObject oApps = this.launchNavigator.getAvailableApps();
            WritableMap mApps = RNUtils.convertJsonToMap(oApps);
            promise.resolve((Object)mApps);
        }
        catch (Exception e) {
            this.handleExceptionWithPromise(promise, e);
        }
    }

    @ReactMethod
    public void isAppAvailable(String appName, Promise promise) {
        try {
            this.logger.debug("isAppAvailable");
            boolean available = this.launchNavigator.isAppAvailable(appName);
            promise.resolve((Object)available);
        }
        catch (Exception e) {
            this.handleExceptionWithPromise(promise, e);
        }
    }

    @ReactMethod
    public void navigate(ReadableMap args, Promise promise) {
        try {
            this.logger.debug("navigate");
            String error = this.launchNavigator.navigate(RNUtils.convertMapToJson(args));
            if (error == null) {
                promise.resolve((Object)true);
            } else {
                promise.reject(ERROR_CODE_ERROR, error);
            }
        }
        catch (Exception e) {
            this.handleExceptionWithPromise(promise, e);
        }
    }

    private void handleExceptionWithPromise(Promise promise, Exception e) {
        promise.reject(ERROR_CODE_EXCEPTION, (Throwable)e);
    }
}

