/*
 * Decompiled with CFR 0.152.
 */
package uk.co.workingedge.RNLaunchNavigator;

import android.util.Log;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import uk.co.workingedge.ILogger;

public class RNLogger
implements ILogger {
    private boolean enabled = false;
    private ReactContext reactContext;
    private String logTag;

    public RNLogger(ReactContext reactContext, String logTag) {
        this.initialize(reactContext, logTag);
    }

    public RNLogger(ReactContext reactContext, String logTag, boolean enabled) {
        this.initialize(reactContext, logTag);
        this.setEnabled(enabled);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void error(String msg) {
        Log.e((String)this.logTag, (String)msg);
        this.logToReactConsole(msg, "error");
    }

    @Override
    public void warn(String msg) {
        Log.w((String)this.logTag, (String)msg);
        this.logToReactConsole(msg, "warn");
    }

    @Override
    public void info(String msg) {
        Log.i((String)this.logTag, (String)msg);
        this.logToReactConsole(msg, "info");
    }

    @Override
    public void debug(String msg) {
        Log.d((String)this.logTag, (String)msg);
        this.logToReactConsole(msg, "log");
    }

    @Override
    public void verbose(String msg) {
        Log.v((String)this.logTag, (String)msg);
        this.logToReactConsole(msg, "debug");
    }

    private void initialize(ReactContext reactContext, String logTag) {
        this.reactContext = reactContext;
        this.logTag = logTag;
    }

    private void logToReactConsole(String message, String logLevel) {
        if (this.reactContext.hasActiveCatalystInstance() && this.enabled) {
            WritableMap map = Arguments.createMap();
            map.putString("logTag", this.logTag);
            map.putString("message", message);
            ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("console." + logLevel, (Object)map);
        }
    }
}

