/*
 * Decompiled with CFR 0.152.
 */
package ua.privatbank.paylibliqpay;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.util.Base64;
import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.util.EncodingUtils;
import org.json.JSONException;
import org.json.JSONObject;
import ua.privatbank.paylibliqpay.LiqPayUtil;
import ua.privatbank.paylibliqpay.LogUtil;

public final class CheckoutActivity
extends Activity {
    WebView mWebView;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRequestedOrientation(1);
        this.setTheme(16974124);
        this.mWebView = new WebView((Context)this);
        this.setContentView((View)this.mWebView);
        final ProgressDialog progressDialog = new ProgressDialog((Context)this);
        progressDialog.setMessage((CharSequence)"Loading...");
        progressDialog.show();
        String postData = this.getIntent().getStringExtra("postData");
        this.mWebView.postUrl(LiqPayUtil.LIQPAY_API_URL_CHECKOUT, EncodingUtils.getBytes((String)postData, (String)"BASE64"));
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                LogUtil.log("==== onPageFinished:" + url);
                progressDialog.cancel();
                super.onPageFinished(view, url);
            }

            public void onLoadResource(WebView view, String url) {
                super.onLoadResource(view, url);
                if (url.contains("checkout/info") && Build.VERSION.SDK_INT < 21 && progressDialog != null) {
                    progressDialog.cancel();
                }
                LogUtil.log(url);
                String startUrl = "/api/mob/webview";
                if (url.contains(startUrl)) {
                    LogUtil.log("==== checkout resp:" + url);
                    try {
                        JSONObject data = CheckoutActivity.parseUrl(url);
                        Intent intent = new Intent("ua.privatbank.paylibliqpay.broadcast");
                        intent.setPackage(CheckoutActivity.this.getPackageName());
                        intent.putExtra("data", data.optString("data"));
                        intent.putExtra("signature", data.optString("signature"));
                        CheckoutActivity.this.sendBroadcast(intent);
                    }
                    catch (Exception var6) {
                        var6.printStackTrace();
                        CheckoutActivity.this.sendBroadcast(new Intent("ua.privatbank.paylibliqpay.broadcast"));
                    }
                    CheckoutActivity.this.finish();
                }
            }
        });
    }

    public static JSONObject parseUrl(String url) throws URISyntaxException, JSONException {
        List params = URLEncodedUtils.parse((URI)new URI(url), (String)"UTF-8");
        JSONObject data = new JSONObject();
        for (NameValuePair param : params) {
            try {
                if ("data".equals(param.getName())) {
                    data.put(param.getName(), (Object)new String(Base64.decode((String)param.getValue(), (int)2)));
                    continue;
                }
                data.put(param.getName(), (Object)param.getValue());
            }
            catch (Exception var6) {
                var6.printStackTrace();
            }
        }
        return data;
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onDestroy() {
        this.mWebView.destroy();
        this.sendBroadcast(new Intent("ua.privatbank.paylibliqpay.broadcast"));
        super.onDestroy();
    }
}

