/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.os.Handler;
import android.os.Looper;
import android.util.JsonReader;
import android.util.JsonToken;
import com.facebook.common.logging.FLog;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.ws.WebSocket;
import okhttp3.ws.WebSocketCall;
import okhttp3.ws.WebSocketListener;
import okio.Buffer;

public class JSPackagerWebSocketClient
implements WebSocketListener {
    private static final String TAG = "JSPackagerWebSocketClient";
    private static final int RECONNECT_DELAY_MS = 2000;
    private final String mUrl;
    private final Handler mHandler;
    private boolean mClosed = false;
    private boolean mSuppressConnectionErrors;
    @Nullable
    private WebSocket mWebSocket;
    @Nullable
    private JSPackagerCallback mCallback;

    public JSPackagerWebSocketClient(String url, JSPackagerCallback callback) {
        this.mUrl = url;
        this.mCallback = callback;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void connect() {
        if (this.mClosed) {
            throw new IllegalStateException("Can't connect closed client");
        }
        OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES).build();
        Request request = new Request.Builder().url(this.mUrl).build();
        WebSocketCall call = WebSocketCall.create((OkHttpClient)httpClient, (Request)request);
        call.enqueue((WebSocketListener)this);
    }

    private void reconnect() {
        if (this.mClosed) {
            throw new IllegalStateException("Can't reconnect closed client");
        }
        if (!this.mSuppressConnectionErrors) {
            FLog.w((String)TAG, (String)"Couldn't connect to packager, will silently retry");
            this.mSuppressConnectionErrors = true;
        }
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!JSPackagerWebSocketClient.this.mClosed) {
                    JSPackagerWebSocketClient.this.connect();
                }
            }
        }, 2000L);
    }

    public void closeQuietly() {
        this.mClosed = true;
        this.closeWebSocketQuietly();
    }

    private void closeWebSocketQuietly() {
        if (this.mWebSocket != null) {
            try {
                this.mWebSocket.close(1000, "End of session");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mWebSocket = null;
        }
    }

    private void triggerMessageCallback(String target, String action) {
        if (this.mCallback != null) {
            this.mCallback.onMessage(this.mWebSocket, target, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ResponseBody response) throws IOException {
        if (response.contentType() != WebSocket.TEXT) {
            FLog.w((String)TAG, (String)("Websocket received unexpected message with payload of type " + response.contentType()));
            return;
        }
        try {
            JsonReader reader = new JsonReader(response.charStream());
            Integer version = null;
            String target = null;
            String action = null;
            reader.beginObject();
            while (reader.hasNext()) {
                String field = reader.nextName();
                if (JsonToken.NULL == reader.peek()) {
                    reader.skipValue();
                    continue;
                }
                if ("version".equals(field)) {
                    version = reader.nextInt();
                    continue;
                }
                if ("target".equals(field)) {
                    target = reader.nextString();
                    continue;
                }
                if (!"action".equals(field)) continue;
                action = reader.nextString();
            }
            if (version != 1) {
                return;
            }
            if (target == null || action == null) {
                return;
            }
            this.triggerMessageCallback(target, action);
        }
        catch (IOException e) {
            this.abort("Parsing response message from websocket failed", e);
        }
        finally {
            response.close();
        }
    }

    public void onFailure(IOException e, Response response) {
        if (this.mWebSocket != null) {
            this.abort("Websocket exception", e);
        }
        if (!this.mClosed) {
            this.reconnect();
        }
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.mWebSocket = webSocket;
        this.mSuppressConnectionErrors = false;
    }

    public void onClose(int code, String reason) {
        this.mWebSocket = null;
        if (!this.mClosed) {
            this.reconnect();
        }
    }

    public void onPong(Buffer payload) {
    }

    private void abort(String message, Throwable cause) {
        FLog.e((String)TAG, (String)("Error occurred, shutting down websocket connection: " + message), (Throwable)cause);
        this.closeWebSocketQuietly();
    }

    public static interface JSPackagerCallback {
        public void onMessage(@Nullable WebSocket var1, String var2, String var3);
    }
}

