/*
 * Decompiled with CFR 0.152.
 */
package com.reactlibrary;

import android.hardware.Camera;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;

public class RNLitModule
extends ReactContextBaseJavaModule
implements LifecycleEventListener {
    private final ReactApplicationContext reactContext;
    private boolean deviceSupportsFlash;
    private CameraManager.TorchCallback torchCallback;
    private String cameraIdWithFlash;
    private CameraManager camManager;
    private static Camera camera;
    private Promise onOffPromise;
    private static final String ERROR_FLASHLIGHT_NOT_AVAILABLE = "500";
    private static final String ERROR_CHANGING_TORCH_MODE = "501";
    private static final String ERROR_CANNOT_ACCESS_CAMERA = "502";

    public RNLitModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
        if (Build.VERSION.SDK_INT >= 23) {
            this.torchCallback = new CameraManager.TorchCallback(){

                public void onTorchModeUnavailable(@NonNull String cameraId) {
                    super.onTorchModeUnavailable(cameraId);
                    if (RNLitModule.this.onOffPromise != null) {
                        RNLitModule.this.onOffPromise.reject(RNLitModule.ERROR_FLASHLIGHT_NOT_AVAILABLE, "Flashlight is not currently available.");
                    }
                }

                public void onTorchModeChanged(@NonNull String cameraId, boolean enabled) {
                    super.onTorchModeChanged(cameraId, enabled);
                    WritableMap obj = Arguments.createMap();
                    obj.putBoolean("isEnabled", enabled);
                    if (RNLitModule.this.onOffPromise != null) {
                        RNLitModule.this.onOffPromise.resolve((Object)obj);
                    }
                }
            };
            this.camManager = (CameraManager)reactContext.getSystemService("camera");
        }
        reactContext.addLifecycleEventListener((LifecycleEventListener)this);
    }

    public String getName() {
        return "RNLit";
    }

    @ReactMethod
    public void isFlashAvail(Promise promise) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.camManager = (CameraManager)this.reactContext.getSystemService("camera");
            String[] cameraIds = null;
            try {
                cameraIds = this.camManager.getCameraIdList();
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
                promise.reject(ERROR_CANNOT_ACCESS_CAMERA, e.getMessage());
            }
            for (String cameraId : cameraIds) {
                CameraCharacteristics characteristics = null;
                try {
                    characteristics = this.camManager.getCameraCharacteristics(cameraId);
                }
                catch (CameraAccessException e) {
                    e.printStackTrace();
                    promise.reject(ERROR_CANNOT_ACCESS_CAMERA, e.getMessage());
                }
                if (characteristics == null || !((Boolean)characteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE)).booleanValue()) continue;
                this.cameraIdWithFlash = cameraId;
                this.deviceSupportsFlash = true;
                break;
            }
        } else {
            this.deviceSupportsFlash = this.reactContext.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
        }
        WritableMap obj = Arguments.createMap();
        obj.putBoolean("deviceSupportsFlash", this.deviceSupportsFlash);
        promise.resolve((Object)obj);
    }

    @ReactMethod
    public void turnOn(boolean turnOnNow, Promise promise) {
        this.onOffPromise = promise;
        if (!this.deviceSupportsFlash) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                this.camManager.setTorchMode(this.cameraIdWithFlash, turnOnNow);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
                promise.reject(ERROR_CHANGING_TORCH_MODE, e.getMessage());
            }
        } else {
            if (camera == null) {
                Log.w((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Camera failed to open");
                this.onOffPromise.reject(ERROR_CANNOT_ACCESS_CAMERA, "Camera is not available");
                return;
            }
            Camera.Parameters p = camera.getParameters();
            WritableMap obj = Arguments.createMap();
            if (turnOnNow) {
                if (p.getSupportedFlashModes().contains("torch")) {
                    p.setFlashMode("torch");
                } else if (p.getSupportedFlashModes().contains("on")) {
                    p.setFlashMode("on");
                }
                camera.setParameters(p);
                camera.startPreview();
            } else {
                p.setFlashMode("off");
                camera.setParameters(p);
                camera.stopPreview();
            }
            obj.putBoolean("isEnabled", turnOnNow);
            this.onOffPromise.resolve((Object)obj);
        }
    }

    public void onHostResume() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.camManager != null) {
                this.camManager.registerTorchCallback(this.torchCallback, null);
            }
        } else {
            camera = Camera.open();
        }
    }

    public void onHostPause() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.camManager != null) {
                this.onOffPromise = null;
                this.camManager.unregisterTorchCallback(this.torchCallback);
            }
        } else {
            camera.release();
        }
    }

    public void onHostDestroy() {
    }
}

