/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstanceImpl;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistration;
import com.facebook.react.bridge.JavaScriptModulesConfig;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import javax.annotation.Nullable;

class JavaScriptModuleRegistry {
    private final HashMap<Class<? extends JavaScriptModule>, JavaScriptModule> mModuleInstances = new HashMap();

    public JavaScriptModuleRegistry(CatalystInstanceImpl instance, JavaScriptModulesConfig config) {
        for (JavaScriptModuleRegistration registration : config.getModuleDefinitions()) {
            Class<? extends JavaScriptModule> moduleInterface = registration.getModuleInterface();
            JavaScriptModule interfaceProxy = (JavaScriptModule)Proxy.newProxyInstance(moduleInterface.getClassLoader(), new Class[]{moduleInterface}, (InvocationHandler)new JavaScriptModuleInvocationHandler(instance, registration));
            this.mModuleInstances.put(moduleInterface, interfaceProxy);
        }
    }

    public <T extends JavaScriptModule> T getJavaScriptModule(Class<T> moduleInterface) {
        return (T)((JavaScriptModule)Assertions.assertNotNull((Object)this.mModuleInstances.get(moduleInterface), (String)("JS module " + moduleInterface.getSimpleName() + " hasn't been registered!")));
    }

    private static class JavaScriptModuleInvocationHandler
    implements InvocationHandler {
        private final CatalystInstanceImpl mCatalystInstance;
        private final JavaScriptModuleRegistration mModuleRegistration;

        public JavaScriptModuleInvocationHandler(CatalystInstanceImpl catalystInstance, JavaScriptModuleRegistration moduleRegistration) {
            this.mCatalystInstance = catalystInstance;
            this.mModuleRegistration = moduleRegistration;
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String tracingName = this.mModuleRegistration.getTracingName(method);
            this.mCatalystInstance.callFunction(this.mModuleRegistration.getModuleId(), this.mModuleRegistration.getMethodId(method), Arguments.fromJavaArgs(args), tracingName);
            return null;
        }
    }
}

