/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.fresco;

import android.content.Context;
import android.support.annotation.Nullable;
import com.facebook.cache.disk.DiskCacheConfig;
import com.facebook.common.internal.AndroidPredicates;
import com.facebook.common.soloader.SoLoaderShim;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.backends.okhttp.OkHttpImagePipelineConfigFactory;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.modules.common.ModuleDataCleaner;
import com.facebook.react.modules.fresco.SystraceRequestListener;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.soloader.SoLoader;
import com.squareup.okhttp.OkHttpClient;
import java.util.HashSet;

public class FrescoModule
extends ReactContextBaseJavaModule
implements ModuleDataCleaner.Cleanable {
    @Nullable
    private ImagePipelineConfig mConfig;

    public FrescoModule(ReactApplicationContext reactContext) {
        this(reactContext, FrescoModule.getDefaultConfig((Context)reactContext, null, null));
    }

    public FrescoModule(ReactApplicationContext reactContext, RequestListener listener) {
        this(reactContext, FrescoModule.getDefaultConfig((Context)reactContext, listener, null));
    }

    public FrescoModule(ReactApplicationContext reactContext, RequestListener listener, DiskCacheConfig diskCacheConfig) {
        this(reactContext, FrescoModule.getDefaultConfig((Context)reactContext, listener, diskCacheConfig));
    }

    public FrescoModule(ReactApplicationContext reactContext, ImagePipelineConfig config) {
        super(reactContext);
        this.mConfig = config;
    }

    @Override
    public void initialize() {
        super.initialize();
        SoLoaderShim.setHandler((SoLoaderShim.Handler)new FrescoHandler());
        Context context = this.getReactApplicationContext().getApplicationContext();
        Fresco.initialize((Context)context, (ImagePipelineConfig)this.mConfig);
        this.mConfig = null;
    }

    @Override
    public String getName() {
        return "FrescoModule";
    }

    @Override
    public void clearSensitiveData() {
        ImagePipelineFactory imagePipelineFactory = Fresco.getImagePipelineFactory();
        imagePipelineFactory.getBitmapMemoryCache().removeAll(AndroidPredicates.True());
        imagePipelineFactory.getEncodedMemoryCache().removeAll(AndroidPredicates.True());
        imagePipelineFactory.getMainDiskStorageCache().clearAll();
        imagePipelineFactory.getSmallImageDiskStorageCache().clearAll();
    }

    private static ImagePipelineConfig getDefaultConfig(Context context, @Nullable RequestListener listener, @Nullable DiskCacheConfig diskCacheConfig) {
        HashSet<RequestListener> requestListeners = new HashSet<RequestListener>();
        requestListeners.add(new SystraceRequestListener());
        if (listener != null) {
            requestListeners.add(listener);
        }
        OkHttpClient okHttpClient = OkHttpClientProvider.getOkHttpClient();
        ImagePipelineConfig.Builder builder = OkHttpImagePipelineConfigFactory.newBuilder((Context)context.getApplicationContext(), (OkHttpClient)okHttpClient);
        builder.setDownsampleEnabled(false).setRequestListeners(requestListeners);
        if (diskCacheConfig != null) {
            builder.setMainDiskCacheConfig(diskCacheConfig);
        }
        return builder.build();
    }

    private static class FrescoHandler
    implements SoLoaderShim.Handler {
        private FrescoHandler() {
        }

        public void loadLibrary(String libraryName) {
            SoLoader.loadLibrary(libraryName);
        }
    }
}

