/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.View;
import android.view.animation.Animation;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.layoutanimation.AbstractLayoutAnimation;
import com.facebook.react.uimanager.layoutanimation.HandleLayout;
import com.facebook.react.uimanager.layoutanimation.LayoutAnimationType;
import com.facebook.react.uimanager.layoutanimation.LayoutCreateAnimation;
import com.facebook.react.uimanager.layoutanimation.LayoutUpdateAnimation;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class LayoutAnimationController {
    private static final boolean ENABLED = true;
    private final AbstractLayoutAnimation mLayoutCreateAnimation = new LayoutCreateAnimation();
    private final AbstractLayoutAnimation mLayoutUpdateAnimation = new LayoutUpdateAnimation();
    private boolean mShouldAnimateLayout;

    public void initializeFromConfig(@Nullable ReadableMap config) {
        int globalDuration;
        if (config == null) {
            this.reset();
            return;
        }
        this.mShouldAnimateLayout = false;
        int n = globalDuration = config.hasKey("duration") ? config.getInt("duration") : 0;
        if (config.hasKey(LayoutAnimationType.CREATE.toString())) {
            this.mLayoutCreateAnimation.initializeFromConfig(config.getMap(LayoutAnimationType.CREATE.toString()), globalDuration);
            this.mShouldAnimateLayout = true;
        }
        if (config.hasKey(LayoutAnimationType.UPDATE.toString())) {
            this.mLayoutUpdateAnimation.initializeFromConfig(config.getMap(LayoutAnimationType.UPDATE.toString()), globalDuration);
            this.mShouldAnimateLayout = true;
        }
    }

    public void reset() {
        this.mLayoutCreateAnimation.reset();
        this.mLayoutUpdateAnimation.reset();
        this.mShouldAnimateLayout = false;
    }

    public boolean shouldAnimateLayout(View viewToAnimate) {
        return this.mShouldAnimateLayout && viewToAnimate.getParent() != null;
    }

    public void applyLayoutUpdate(View view, int x, int y, int width, int height) {
        UiThreadUtil.assertOnUiThread();
        AbstractLayoutAnimation layoutAnimation = view.getWidth() == 0 || view.getHeight() == 0 ? this.mLayoutCreateAnimation : this.mLayoutUpdateAnimation;
        Animation animation = layoutAnimation.createAnimation(view, x, y, width, height);
        if (animation == null || !(animation instanceof HandleLayout)) {
            view.layout(x, y, x + width, y + height);
        }
        if (animation != null) {
            view.startAnimation(animation);
        }
    }
}

