/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.scroll.ReactHorizontalScrollView;
import com.facebook.react.views.scroll.ReactScrollViewCommandHelper;
import javax.annotation.Nullable;

public class ReactHorizontalScrollViewManager
extends ViewGroupManager<ReactHorizontalScrollView>
implements ReactScrollViewCommandHelper.ScrollCommandHandler<ReactHorizontalScrollView> {
    private static final String REACT_CLASS = "AndroidHorizontalScrollView";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactHorizontalScrollView createViewInstance(ThemedReactContext context) {
        return new ReactHorizontalScrollView((Context)context);
    }

    @ReactProp(name="scrollEnabled", defaultBoolean=true)
    public void setScrollEnabled(ReactHorizontalScrollView view, boolean value) {
        view.setScrollEnabled(value);
    }

    @ReactProp(name="showsHorizontalScrollIndicator")
    public void setShowsHorizontalScrollIndicator(ReactHorizontalScrollView view, boolean value) {
        view.setHorizontalScrollBarEnabled(value);
    }

    @ReactProp(name="removeClippedSubviews")
    public void setRemoveClippedSubviews(ReactHorizontalScrollView view, boolean removeClippedSubviews) {
        view.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @ReactProp(name="sendMomentumEvents")
    public void setSendMomentumEvents(ReactHorizontalScrollView view, boolean sendMomentumEvents) {
        view.setSendMomentumEvents(sendMomentumEvents);
    }

    @Override
    public void receiveCommand(ReactHorizontalScrollView scrollView, int commandId, @Nullable ReadableArray args) {
        ReactScrollViewCommandHelper.receiveCommand(this, scrollView, commandId, args);
    }

    @Override
    public void scrollTo(ReactHorizontalScrollView scrollView, ReactScrollViewCommandHelper.ScrollToCommandData data) {
        if (data.mAnimated) {
            scrollView.smoothScrollTo(data.mDestX, data.mDestY);
        } else {
            scrollView.scrollTo(data.mDestX, data.mDestY);
        }
    }
}

