/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextWatcher;
import android.text.method.KeyListener;
import android.text.method.QwertyKeyListener;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.views.text.CustomStyleSpan;
import com.facebook.react.views.text.ReactTagSpan;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.textinput.SelectionWatcher;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class ReactEditText
extends EditText {
    private final InputMethodManager mInputMethodManager;
    private boolean mIsSettingTextFromJS;
    private boolean mIsJSSettingFocus;
    private int mDefaultGravityHorizontal;
    private int mDefaultGravityVertical;
    private int mNativeEventCount;
    @Nullable
    private ArrayList<TextWatcher> mListeners;
    @Nullable
    private TextWatcherDelegator mTextWatcherDelegator;
    private int mStagedInputType;
    private boolean mContainsImages;
    @Nullable
    private SelectionWatcher mSelectionWatcher;
    private final InternalKeyListener mKeyListener;
    private static final KeyListener sKeyListener = QwertyKeyListener.getInstanceForFullKeyboard();

    public ReactEditText(Context context) {
        super(context);
        this.setFocusableInTouchMode(false);
        this.mInputMethodManager = (InputMethodManager)Assertions.assertNotNull((Object)this.getContext().getSystemService("input_method"));
        this.mDefaultGravityHorizontal = this.getGravity() & 0x800007;
        this.mDefaultGravityVertical = this.getGravity() & 0x70;
        this.mNativeEventCount = 0;
        this.mIsSettingTextFromJS = false;
        this.mIsJSSettingFocus = false;
        this.mListeners = null;
        this.mTextWatcherDelegator = null;
        this.mStagedInputType = this.getInputType();
        this.mKeyListener = new InternalKeyListener();
    }

    public boolean isLayoutRequested() {
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 66 && (this.getInputType() & 0x20000) == 0) {
            this.hideSoftKeyboard();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void clearFocus() {
        this.setFocusableInTouchMode(false);
        super.clearFocus();
        this.hideSoftKeyboard();
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (this.isFocused()) {
            return true;
        }
        if (!this.mIsJSSettingFocus) {
            return false;
        }
        this.setFocusableInTouchMode(true);
        boolean focused = super.requestFocus(direction, previouslyFocusedRect);
        this.showSoftKeyboard();
        return focused;
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
            super.addTextChangedListener((TextWatcher)this.getTextWatcherDelegator());
        }
        this.mListeners.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        if (this.mListeners != null) {
            this.mListeners.remove(watcher);
            if (this.mListeners.isEmpty()) {
                this.mListeners = null;
                super.removeTextChangedListener((TextWatcher)this.getTextWatcherDelegator());
            }
        }
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (this.mSelectionWatcher != null && this.hasFocus()) {
            this.mSelectionWatcher.onSelectionChanged(selStart, selEnd);
        }
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused && this.mSelectionWatcher != null) {
            this.mSelectionWatcher.onSelectionChanged(this.getSelectionStart(), this.getSelectionEnd());
        }
    }

    public void setSelectionWatcher(SelectionWatcher selectionWatcher) {
        this.mSelectionWatcher = selectionWatcher;
    }

    int getStagedInputType() {
        return this.mStagedInputType;
    }

    void setStagedInputType(int stagedInputType) {
        this.mStagedInputType = stagedInputType;
    }

    void commitStagedInputType() {
        if (this.getInputType() != this.mStagedInputType) {
            this.setInputType(this.mStagedInputType);
        }
    }

    public void setInputType(int type) {
        super.setInputType(type);
        this.mStagedInputType = type;
        this.mKeyListener.setInputType(type);
        this.setKeyListener(this.mKeyListener);
    }

    public void requestFocusFromJS() {
        this.mIsJSSettingFocus = true;
        this.requestFocus();
        this.mIsJSSettingFocus = false;
    }

    void clearFocusFromJS() {
        this.clearFocus();
    }

    public int incrementAndGetEventCounter() {
        return ++this.mNativeEventCount;
    }

    public void maybeSetText(ReactTextUpdate reactTextUpdate) {
        if (reactTextUpdate.getJsEventCounter() < this.mNativeEventCount) {
            return;
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)reactTextUpdate.getText());
        this.manageSpans(spannableStringBuilder);
        this.mContainsImages = reactTextUpdate.containsImages();
        this.mIsSettingTextFromJS = true;
        this.getText().replace(0, this.length(), (CharSequence)spannableStringBuilder);
        this.mIsSettingTextFromJS = false;
    }

    private void manageSpans(SpannableStringBuilder spannableStringBuilder) {
        Object[] spans = this.getText().getSpans(0, this.length(), Object.class);
        for (int spanIdx = 0; spanIdx < spans.length; ++spanIdx) {
            if (ForegroundColorSpan.class.isInstance(spans[spanIdx]) || BackgroundColorSpan.class.isInstance(spans[spanIdx]) || AbsoluteSizeSpan.class.isInstance(spans[spanIdx]) || CustomStyleSpan.class.isInstance(spans[spanIdx]) || ReactTagSpan.class.isInstance(spans[spanIdx])) {
                this.getText().removeSpan(spans[spanIdx]);
            }
            if ((this.getText().getSpanFlags(spans[spanIdx]) & 0x21) != 33) continue;
            Object span = spans[spanIdx];
            int spanStart = this.getText().getSpanStart(spans[spanIdx]);
            int spanEnd = this.getText().getSpanEnd(spans[spanIdx]);
            int spanFlags = this.getText().getSpanFlags(spans[spanIdx]);
            this.getText().removeSpan(spans[spanIdx]);
            if (!ReactEditText.sameTextForSpan(this.getText(), spannableStringBuilder, spanStart, spanEnd)) continue;
            spannableStringBuilder.setSpan(span, spanStart, spanEnd, spanFlags);
        }
    }

    private static boolean sameTextForSpan(Editable oldText, SpannableStringBuilder newText, int start, int end) {
        if (start > newText.length() || end > newText.length()) {
            return false;
        }
        for (int charIdx = start; charIdx < end; ++charIdx) {
            if (oldText.charAt(charIdx) == newText.charAt(charIdx)) continue;
            return false;
        }
        return true;
    }

    private boolean showSoftKeyboard() {
        return this.mInputMethodManager.showSoftInput((View)this, 0);
    }

    private void hideSoftKeyboard() {
        this.mInputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    private TextWatcherDelegator getTextWatcherDelegator() {
        if (this.mTextWatcherDelegator == null) {
            this.mTextWatcherDelegator = new TextWatcherDelegator();
        }
        return this.mTextWatcherDelegator;
    }

    void setGravityHorizontal(int gravityHorizontal) {
        if (gravityHorizontal == 0) {
            gravityHorizontal = this.mDefaultGravityHorizontal;
        }
        this.setGravity(this.getGravity() & 0xFFFFFFF8 & 0xFF7FFFF8 | gravityHorizontal);
    }

    void setGravityVertical(int gravityVertical) {
        if (gravityVertical == 0) {
            gravityVertical = this.mDefaultGravityVertical;
        }
        this.setGravity(this.getGravity() & 0xFFFFFF8F | gravityVertical);
    }

    protected boolean verifyDrawable(Drawable drawable) {
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable) continue;
                return true;
            }
        }
        return super.verifyDrawable(drawable);
    }

    public void invalidateDrawable(Drawable drawable) {
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                if (span.getDrawable() != drawable) continue;
                this.invalidate();
            }
        }
        super.invalidateDrawable(drawable);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onDetachedFromWindow();
            }
        }
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onStartTemporaryDetach();
            }
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onAttachedToWindow();
            }
        }
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        if (this.mContainsImages && this.getText() instanceof Spanned) {
            TextInlineImageSpan[] spans;
            Editable text = this.getText();
            for (TextInlineImageSpan span : spans = (TextInlineImageSpan[])text.getSpans(0, text.length(), TextInlineImageSpan.class)) {
                span.onFinishTemporaryDetach();
            }
        }
    }

    private static class InternalKeyListener
    implements KeyListener {
        private int mInputType = 0;

        public void setInputType(int inputType) {
            this.mInputType = inputType;
        }

        public int getInputType() {
            return this.mInputType;
        }

        public boolean onKeyDown(View view, Editable text, int keyCode, KeyEvent event) {
            return sKeyListener.onKeyDown(view, text, keyCode, event);
        }

        public boolean onKeyUp(View view, Editable text, int keyCode, KeyEvent event) {
            return sKeyListener.onKeyUp(view, text, keyCode, event);
        }

        public boolean onKeyOther(View view, Editable text, KeyEvent event) {
            return sKeyListener.onKeyOther(view, text, event);
        }

        public void clearMetaKeyState(View view, Editable content, int states) {
            sKeyListener.clearMetaKeyState(view, content, states);
        }
    }

    private class TextWatcherDelegator
    implements TextWatcher {
        private TextWatcherDelegator() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            if (!ReactEditText.this.mIsSettingTextFromJS && ReactEditText.this.mListeners != null) {
                for (TextWatcher listener : ReactEditText.this.mListeners) {
                    listener.beforeTextChanged(s, start, count, after);
                }
            }
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (!ReactEditText.this.mIsSettingTextFromJS && ReactEditText.this.mListeners != null) {
                for (TextWatcher listener : ReactEditText.this.mListeners) {
                    listener.onTextChanged(s, start, before, count);
                }
            }
        }

        public void afterTextChanged(Editable s) {
            if (!ReactEditText.this.mIsSettingTextFromJS && ReactEditText.this.mListeners != null) {
                for (TextWatcher listener : ReactEditText.this.mListeners) {
                    listener.afterTextChanged(s);
                }
            }
        }
    }
}

