/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.airbnb.android.react.maps.AirMapCircle;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.google.android.gms.maps.model.LatLng;

public class AirMapCircleManager
extends ViewGroupManager<AirMapCircle> {
    private final DisplayMetrics metrics;

    public AirMapCircleManager(ReactApplicationContext reactContext) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.metrics = new DisplayMetrics();
            ((WindowManager)reactContext.getSystemService("window")).getDefaultDisplay().getRealMetrics(this.metrics);
        } else {
            this.metrics = reactContext.getResources().getDisplayMetrics();
        }
    }

    public String getName() {
        return "AIRMapCircle";
    }

    public AirMapCircle createViewInstance(ThemedReactContext context) {
        return new AirMapCircle((Context)context);
    }

    @ReactProp(name="center")
    public void setCenter(AirMapCircle view, ReadableMap center) {
        view.setCenter(new LatLng(center.getDouble("latitude"), center.getDouble("longitude")));
    }

    @ReactProp(name="radius", defaultDouble=0.0)
    public void setRadius(AirMapCircle view, double radius) {
        view.setRadius(radius);
    }

    @ReactProp(name="strokeWidth", defaultFloat=1.0f)
    public void setStrokeWidth(AirMapCircle view, float widthInPoints) {
        float widthInScreenPx = this.metrics.density * widthInPoints;
        view.setStrokeWidth(widthInScreenPx);
    }

    @ReactProp(name="fillColor", defaultInt=-65536, customType="Color")
    public void setFillColor(AirMapCircle view, int color) {
        view.setFillColor(color);
    }

    @ReactProp(name="strokeColor", defaultInt=-65536, customType="Color")
    public void setStrokeColor(AirMapCircle view, int color) {
        view.setStrokeColor(color);
    }

    @ReactProp(name="zIndex", defaultFloat=1.0f)
    public void setZIndex(AirMapCircle view, float zIndex) {
        view.setZIndex(zIndex);
    }
}

