/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import android.view.View;
import com.airbnb.android.react.maps.AirMapView;
import com.airbnb.android.react.maps.SizeReportingShadowNode;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.MapStyleOptions;
import java.util.Map;
import javax.annotation.Nullable;

public class AirMapManager
extends ViewGroupManager<AirMapView> {
    private static final String REACT_CLASS = "AIRMap";
    private static final int ANIMATE_TO_REGION = 1;
    private static final int ANIMATE_TO_COORDINATE = 2;
    private static final int ANIMATE_TO_VIEWING_ANGLE = 3;
    private static final int ANIMATE_TO_BEARING = 4;
    private static final int FIT_TO_ELEMENTS = 5;
    private static final int FIT_TO_SUPPLIED_MARKERS = 6;
    private static final int FIT_TO_COORDINATES = 7;
    private final Map<String, Integer> MAP_TYPES = MapBuilder.of((Object)"standard", (Object)1, (Object)"satellite", (Object)2, (Object)"hybrid", (Object)4, (Object)"terrain", (Object)3, (Object)"none", (Object)0);
    private final ReactApplicationContext appContext;
    protected GoogleMapOptions googleMapOptions;

    public AirMapManager(ReactApplicationContext context) {
        this.appContext = context;
        this.googleMapOptions = new GoogleMapOptions();
    }

    public String getName() {
        return REACT_CLASS;
    }

    protected AirMapView createViewInstance(ThemedReactContext context) {
        return new AirMapView(context, this.appContext, this, this.googleMapOptions);
    }

    private void emitMapError(ThemedReactContext context, String message, String type) {
        WritableMap error = Arguments.createMap();
        error.putString("message", message);
        error.putString("type", type);
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)context.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("onError", (Object)error);
    }

    @ReactProp(name="region")
    public void setRegion(AirMapView view, ReadableMap region) {
        view.setRegion(region);
    }

    @ReactProp(name="initialRegion")
    public void setInitialRegion(AirMapView view, ReadableMap initialRegion) {
        view.setInitialRegion(initialRegion);
    }

    @ReactProp(name="mapType")
    public void setMapType(AirMapView view, @Nullable String mapType) {
        int typeId = this.MAP_TYPES.get(mapType);
        view.map.setMapType(typeId);
    }

    @ReactProp(name="customMapStyleString")
    public void setMapStyle(AirMapView view, @Nullable String customMapStyleString) {
        view.map.setMapStyle(new MapStyleOptions(customMapStyleString));
    }

    @ReactProp(name="showsUserLocation", defaultBoolean=false)
    public void setShowsUserLocation(AirMapView view, boolean showUserLocation) {
        view.setShowsUserLocation(showUserLocation);
    }

    @ReactProp(name="showsMyLocationButton", defaultBoolean=true)
    public void setShowsMyLocationButton(AirMapView view, boolean showMyLocationButton) {
        view.setShowsMyLocationButton(showMyLocationButton);
    }

    @ReactProp(name="toolbarEnabled", defaultBoolean=true)
    public void setToolbarEnabled(AirMapView view, boolean toolbarEnabled) {
        view.setToolbarEnabled(toolbarEnabled);
    }

    @ReactProp(name="handlePanDrag", defaultBoolean=false)
    public void setHandlePanDrag(AirMapView view, boolean handlePanDrag) {
        view.setHandlePanDrag(handlePanDrag);
    }

    @ReactProp(name="showsTraffic", defaultBoolean=false)
    public void setShowTraffic(AirMapView view, boolean showTraffic) {
        view.map.setTrafficEnabled(showTraffic);
    }

    @ReactProp(name="showsBuildings", defaultBoolean=false)
    public void setShowBuildings(AirMapView view, boolean showBuildings) {
        view.map.setBuildingsEnabled(showBuildings);
    }

    @ReactProp(name="showsIndoors", defaultBoolean=false)
    public void setShowIndoors(AirMapView view, boolean showIndoors) {
        view.map.setIndoorEnabled(showIndoors);
    }

    @ReactProp(name="showsIndoorLevelPicker", defaultBoolean=false)
    public void setShowsIndoorLevelPicker(AirMapView view, boolean showsIndoorLevelPicker) {
        view.map.getUiSettings().setIndoorLevelPickerEnabled(showsIndoorLevelPicker);
    }

    @ReactProp(name="showsCompass", defaultBoolean=false)
    public void setShowsCompass(AirMapView view, boolean showsCompass) {
        view.map.getUiSettings().setCompassEnabled(showsCompass);
    }

    @ReactProp(name="scrollEnabled", defaultBoolean=false)
    public void setScrollEnabled(AirMapView view, boolean scrollEnabled) {
        view.map.getUiSettings().setScrollGesturesEnabled(scrollEnabled);
    }

    @ReactProp(name="zoomEnabled", defaultBoolean=false)
    public void setZoomEnabled(AirMapView view, boolean zoomEnabled) {
        view.map.getUiSettings().setZoomGesturesEnabled(zoomEnabled);
    }

    @ReactProp(name="rotateEnabled", defaultBoolean=false)
    public void setRotateEnabled(AirMapView view, boolean rotateEnabled) {
        view.map.getUiSettings().setRotateGesturesEnabled(rotateEnabled);
    }

    @ReactProp(name="cacheEnabled", defaultBoolean=false)
    public void setCacheEnabled(AirMapView view, boolean cacheEnabled) {
        view.setCacheEnabled(cacheEnabled);
    }

    @ReactProp(name="loadingEnabled", defaultBoolean=false)
    public void setLoadingEnabled(AirMapView view, boolean loadingEnabled) {
        view.enableMapLoading(loadingEnabled);
    }

    @ReactProp(name="moveOnMarkerPress", defaultBoolean=true)
    public void setMoveOnMarkerPress(AirMapView view, boolean moveOnPress) {
        view.setMoveOnMarkerPress(moveOnPress);
    }

    @ReactProp(name="loadingBackgroundColor", customType="Color")
    public void setLoadingBackgroundColor(AirMapView view, @Nullable Integer loadingBackgroundColor) {
        view.setLoadingBackgroundColor(loadingBackgroundColor);
    }

    @ReactProp(name="loadingIndicatorColor", customType="Color")
    public void setLoadingIndicatorColor(AirMapView view, @Nullable Integer loadingIndicatorColor) {
        view.setLoadingIndicatorColor(loadingIndicatorColor);
    }

    @ReactProp(name="pitchEnabled", defaultBoolean=false)
    public void setPitchEnabled(AirMapView view, boolean pitchEnabled) {
        view.map.getUiSettings().setTiltGesturesEnabled(pitchEnabled);
    }

    @ReactProp(name="minZoomLevel")
    public void setMinZoomLevel(AirMapView view, float minZoomLevel) {
        view.map.setMinZoomPreference(minZoomLevel);
    }

    @ReactProp(name="maxZoomLevel")
    public void setMaxZoomLevel(AirMapView view, float maxZoomLevel) {
        view.map.setMaxZoomPreference(maxZoomLevel);
    }

    public void receiveCommand(AirMapView view, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                ReadableMap region = args.getMap(0);
                Integer duration = args.getInt(1);
                Double lng = region.getDouble("longitude");
                Double lat = region.getDouble("latitude");
                Double lngDelta = region.getDouble("longitudeDelta");
                Double latDelta = region.getDouble("latitudeDelta");
                LatLngBounds bounds = new LatLngBounds(new LatLng(lat - latDelta / 2.0, lng - lngDelta / 2.0), new LatLng(lat + latDelta / 2.0, lng + lngDelta / 2.0));
                view.animateToRegion(bounds, duration);
                break;
            }
            case 2: {
                ReadableMap region = args.getMap(0);
                Integer duration = args.getInt(1);
                Double lng = region.getDouble("longitude");
                Double lat = region.getDouble("latitude");
                view.animateToCoordinate(new LatLng(lat.doubleValue(), lng.doubleValue()), duration);
                break;
            }
            case 3: {
                float angle = (float)args.getDouble(0);
                Integer duration = args.getInt(1);
                view.animateToViewingAngle(angle, duration);
                break;
            }
            case 4: {
                float bearing = (float)args.getDouble(0);
                Integer duration = args.getInt(1);
                view.animateToBearing(bearing, duration);
                break;
            }
            case 5: {
                view.fitToElements(args.getBoolean(0));
                break;
            }
            case 6: {
                view.fitToSuppliedMarkers(args.getArray(0), args.getBoolean(1));
                break;
            }
            case 7: {
                view.fitToCoordinates(args.getArray(0), args.getMap(1), args.getBoolean(2));
            }
        }
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        Map map = MapBuilder.of((Object)"onMapReady", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMapReady"), (Object)"onPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPress"), (Object)"onLongPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onLongPress"), (Object)"onMarkerPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerPress"), (Object)"onMarkerSelect", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerSelect"), (Object)"onMarkerDeselect", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDeselect"), (Object)"onCalloutPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onCalloutPress"));
        map.putAll(MapBuilder.of((Object)"onMarkerDragStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDragStart"), (Object)"onMarkerDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDrag"), (Object)"onMarkerDragEnd", (Object)MapBuilder.of((Object)"registrationName", (Object)"onMarkerDragEnd"), (Object)"onPanDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPanDrag")));
        return map;
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"animateToRegion", (Object)1, (Object)"animateToCoordinate", (Object)2, (Object)"animateToViewingAngle", (Object)3, (Object)"animateToBearing", (Object)4, (Object)"fitToElements", (Object)5, (Object)"fitToSuppliedMarkers", (Object)6, (Object)"fitToCoordinates", (Object)7);
    }

    public LayoutShadowNode createShadowNodeInstance() {
        return new SizeReportingShadowNode();
    }

    public void addView(AirMapView parent, View child, int index) {
        parent.addFeature(child, index);
    }

    public int getChildCount(AirMapView view) {
        return view.getFeatureCount();
    }

    public View getChildAt(AirMapView view, int index) {
        return view.getFeatureAt(index);
    }

    public void removeViewAt(AirMapView parent, int index) {
        parent.removeFeatureAt(index);
    }

    public void updateExtraData(AirMapView view, Object extraData) {
        view.updateExtraData(extraData);
    }

    void pushEvent(ThemedReactContext context, View view, String name, WritableMap data) {
        ((RCTEventEmitter)context.getJSModule(RCTEventEmitter.class)).receiveEvent(view.getId(), name, data);
    }

    public void onDropViewInstance(AirMapView view) {
        view.doDestroy();
        super.onDropViewInstance((View)view);
    }
}

