/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.airbnb.android.react.maps.AirMapPolygon;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import java.util.Map;
import javax.annotation.Nullable;

public class AirMapPolygonManager
extends ViewGroupManager<AirMapPolygon> {
    private final DisplayMetrics metrics;

    public AirMapPolygonManager(ReactApplicationContext reactContext) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.metrics = new DisplayMetrics();
            ((WindowManager)reactContext.getSystemService("window")).getDefaultDisplay().getRealMetrics(this.metrics);
        } else {
            this.metrics = reactContext.getResources().getDisplayMetrics();
        }
    }

    public String getName() {
        return "AIRMapPolygon";
    }

    public AirMapPolygon createViewInstance(ThemedReactContext context) {
        return new AirMapPolygon((Context)context);
    }

    @ReactProp(name="coordinates")
    public void setCoordinate(AirMapPolygon view, ReadableArray coordinates) {
        view.setCoordinates(coordinates);
    }

    @ReactProp(name="strokeWidth", defaultFloat=1.0f)
    public void setStrokeWidth(AirMapPolygon view, float widthInPoints) {
        float widthInScreenPx = this.metrics.density * widthInPoints;
        view.setStrokeWidth(widthInScreenPx);
    }

    @ReactProp(name="fillColor", defaultInt=-65536, customType="Color")
    public void setFillColor(AirMapPolygon view, int color) {
        view.setFillColor(color);
    }

    @ReactProp(name="strokeColor", defaultInt=-65536, customType="Color")
    public void setStrokeColor(AirMapPolygon view, int color) {
        view.setStrokeColor(color);
    }

    @ReactProp(name="geodesic", defaultBoolean=false)
    public void setGeodesic(AirMapPolygon view, boolean geodesic) {
        view.setGeodesic(geodesic);
    }

    @ReactProp(name="zIndex", defaultFloat=1.0f)
    public void setZIndex(AirMapPolygon view, float zIndex) {
        view.setZIndex(zIndex);
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of((Object)"onPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPress"));
    }
}

