/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import android.content.Context;
import com.airbnb.android.react.maps.AirMapFeature;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import java.util.ArrayList;
import java.util.List;

public class AirMapPolyline
extends AirMapFeature {
    private PolylineOptions polylineOptions;
    private Polyline polyline;
    private List<LatLng> coordinates;
    private int color;
    private float width;
    private boolean geodesic;
    private float zIndex;

    public AirMapPolyline(Context context) {
        super(context);
    }

    public void setCoordinates(ReadableArray coordinates) {
        this.coordinates = new ArrayList<LatLng>(coordinates.size());
        for (int i = 0; i < coordinates.size(); ++i) {
            ReadableMap coordinate = coordinates.getMap(i);
            this.coordinates.add(i, new LatLng(coordinate.getDouble("latitude"), coordinate.getDouble("longitude")));
        }
        if (this.polyline != null) {
            this.polyline.setPoints(this.coordinates);
        }
    }

    public void setColor(int color) {
        this.color = color;
        if (this.polyline != null) {
            this.polyline.setColor(color);
        }
    }

    public void setWidth(float width) {
        this.width = width;
        if (this.polyline != null) {
            this.polyline.setWidth(width);
        }
    }

    public void setZIndex(float zIndex) {
        this.zIndex = zIndex;
        if (this.polyline != null) {
            this.polyline.setZIndex(zIndex);
        }
    }

    public void setGeodesic(boolean geodesic) {
        this.geodesic = geodesic;
        if (this.polyline != null) {
            this.polyline.setGeodesic(geodesic);
        }
    }

    public PolylineOptions getPolylineOptions() {
        if (this.polylineOptions == null) {
            this.polylineOptions = this.createPolylineOptions();
        }
        return this.polylineOptions;
    }

    private PolylineOptions createPolylineOptions() {
        PolylineOptions options = new PolylineOptions();
        options.addAll(this.coordinates);
        options.color(this.color);
        options.width(this.width);
        options.geodesic(this.geodesic);
        options.zIndex(this.zIndex);
        return options;
    }

    @Override
    public Object getFeature() {
        return this.polyline;
    }

    @Override
    public void addToMap(GoogleMap map) {
        this.polyline = map.addPolyline(this.getPolylineOptions());
        this.polyline.setClickable(true);
    }

    @Override
    public void removeFromMap(GoogleMap map) {
        this.polyline.remove();
    }
}

