/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import android.content.Context;
import com.airbnb.android.react.maps.AirMapFeature;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.TileProvider;
import com.google.android.gms.maps.model.UrlTileProvider;
import java.net.MalformedURLException;
import java.net.URL;

public class AirMapUrlTile
extends AirMapFeature {
    private TileOverlayOptions tileOverlayOptions;
    private TileOverlay tileOverlay;
    private AIRMapUrlTileProvider tileProvider;
    private String urlTemplate;
    private float zIndex;

    public AirMapUrlTile(Context context) {
        super(context);
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
        if (this.tileProvider != null) {
            this.tileProvider.setUrlTemplate(urlTemplate);
        }
        if (this.tileOverlay != null) {
            this.tileOverlay.clearTileCache();
        }
    }

    public void setZIndex(float zIndex) {
        this.zIndex = zIndex;
        if (this.tileOverlay != null) {
            this.tileOverlay.setZIndex(zIndex);
        }
    }

    public TileOverlayOptions getTileOverlayOptions() {
        if (this.tileOverlayOptions == null) {
            this.tileOverlayOptions = this.createTileOverlayOptions();
        }
        return this.tileOverlayOptions;
    }

    private TileOverlayOptions createTileOverlayOptions() {
        TileOverlayOptions options = new TileOverlayOptions();
        options.zIndex(this.zIndex);
        this.tileProvider = new AIRMapUrlTileProvider(256, 256, this.urlTemplate);
        options.tileProvider((TileProvider)this.tileProvider);
        return options;
    }

    @Override
    public Object getFeature() {
        return this.tileOverlay;
    }

    @Override
    public void addToMap(GoogleMap map) {
        this.tileOverlay = map.addTileOverlay(this.getTileOverlayOptions());
    }

    @Override
    public void removeFromMap(GoogleMap map) {
        this.tileOverlay.remove();
    }

    class AIRMapUrlTileProvider
    extends UrlTileProvider {
        private String urlTemplate;

        public AIRMapUrlTileProvider(int width, int height, String urlTemplate) {
            super(width, height);
            this.urlTemplate = urlTemplate;
        }

        public synchronized URL getTileUrl(int x, int y, int zoom) {
            String s = this.urlTemplate.replace("{x}", Integer.toString(x)).replace("{y}", Integer.toString(y)).replace("{z}", Integer.toString(zoom));
            URL url = null;
            try {
                url = new URL(s);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            return url;
        }

        public void setUrlTemplate(String urlTemplate) {
            this.urlTemplate = urlTemplate;
        }
    }
}

