/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.Animatable;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.airbnb.android.react.maps.AirMapCallout;
import com.airbnb.android.react.maps.AirMapFeature;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeHolder;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImageInfo;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.react.bridge.ReadableMap;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import javax.annotation.Nullable;

public class AirMapMarker
extends AirMapFeature {
    private MarkerOptions markerOptions;
    private Marker marker;
    private int width;
    private int height;
    private String identifier;
    private LatLng position;
    private String title;
    private String snippet;
    private boolean anchorIsSet;
    private float anchorX;
    private float anchorY;
    private AirMapCallout calloutView;
    private View wrappedCalloutView;
    private final Context context;
    private float markerHue = 0.0f;
    private BitmapDescriptor iconBitmapDescriptor;
    private Bitmap iconBitmap;
    private float rotation = 0.0f;
    private boolean flat = false;
    private boolean draggable = false;
    private int zIndex = 0;
    private float opacity = 1.0f;
    private float calloutAnchorX;
    private float calloutAnchorY;
    private boolean calloutAnchorIsSet;
    private boolean hasCustomMarkerView = false;
    private final DraweeHolder<?> logoHolder;
    private DataSource<CloseableReference<CloseableImage>> dataSource;
    private final ControllerListener<ImageInfo> mLogoControllerListener = new BaseControllerListener<ImageInfo>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFinalImageSet(String id, @Nullable ImageInfo imageInfo, @Nullable Animatable animatable) {
            CloseableReference imageReference = null;
            try {
                CloseableStaticBitmap closeableStaticBitmap;
                Bitmap bitmap;
                CloseableImage image;
                imageReference = (CloseableReference)AirMapMarker.this.dataSource.getResult();
                if (imageReference != null && (image = (CloseableImage)imageReference.get()) != null && image instanceof CloseableStaticBitmap && (bitmap = (closeableStaticBitmap = (CloseableStaticBitmap)image).getUnderlyingBitmap()) != null) {
                    bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
                    AirMapMarker.this.iconBitmap = bitmap;
                    AirMapMarker.this.iconBitmapDescriptor = BitmapDescriptorFactory.fromBitmap((Bitmap)bitmap);
                }
            }
            finally {
                AirMapMarker.this.dataSource.close();
                if (imageReference != null) {
                    CloseableReference.closeSafely((CloseableReference)imageReference);
                }
            }
            AirMapMarker.this.update();
        }
    };

    public AirMapMarker(Context context) {
        super(context);
        this.context = context;
        this.logoHolder = DraweeHolder.create((DraweeHierarchy)this.createDraweeHierarchy(), (Context)context);
        this.logoHolder.onAttach();
    }

    private GenericDraweeHierarchy createDraweeHierarchy() {
        return new GenericDraweeHierarchyBuilder(this.getResources()).setActualImageScaleType(ScalingUtils.ScaleType.FIT_CENTER).setFadeDuration(0).build();
    }

    public void setCoordinate(ReadableMap coordinate) {
        this.position = new LatLng(coordinate.getDouble("latitude"), coordinate.getDouble("longitude"));
        if (this.marker != null) {
            this.marker.setPosition(this.position);
        }
        this.update();
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
        this.update();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.marker != null) {
            this.marker.setTitle(title);
        }
        this.update();
    }

    public void setSnippet(String snippet) {
        this.snippet = snippet;
        if (this.marker != null) {
            this.marker.setSnippet(snippet);
        }
        this.update();
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        if (this.marker != null) {
            this.marker.setRotation(rotation);
        }
        this.update();
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
        if (this.marker != null) {
            this.marker.setFlat(flat);
        }
        this.update();
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
        if (this.marker != null) {
            this.marker.setDraggable(draggable);
        }
        this.update();
    }

    public void setZIndex(int zIndex) {
        this.zIndex = zIndex;
        if (this.marker != null) {
            this.marker.setZIndex((float)zIndex);
        }
        this.update();
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
        if (this.marker != null) {
            this.marker.setAlpha(opacity);
        }
        this.update();
    }

    public void setMarkerHue(float markerHue) {
        this.markerHue = markerHue;
        this.update();
    }

    public void setAnchor(double x, double y) {
        this.anchorIsSet = true;
        this.anchorX = (float)x;
        this.anchorY = (float)y;
        if (this.marker != null) {
            this.marker.setAnchor(this.anchorX, this.anchorY);
        }
        this.update();
    }

    public void setCalloutAnchor(double x, double y) {
        this.calloutAnchorIsSet = true;
        this.calloutAnchorX = (float)x;
        this.calloutAnchorY = (float)y;
        if (this.marker != null) {
            this.marker.setInfoWindowAnchor(this.calloutAnchorX, this.calloutAnchorY);
        }
        this.update();
    }

    public void setImage(String uri) {
        if (uri == null) {
            this.iconBitmapDescriptor = null;
            this.update();
        } else if (uri.startsWith("http://") || uri.startsWith("https://") || uri.startsWith("file://")) {
            ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)Uri.parse((String)uri)).build();
            ImagePipeline imagePipeline = Fresco.getImagePipeline();
            this.dataSource = imagePipeline.fetchDecodedImage(imageRequest, (Object)this);
            AbstractDraweeController controller = ((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)((PipelineDraweeControllerBuilder)Fresco.newDraweeControllerBuilder().setImageRequest((Object)imageRequest)).setControllerListener(this.mLogoControllerListener)).setOldController(this.logoHolder.getController())).build();
            this.logoHolder.setController((DraweeController)controller);
        } else {
            this.iconBitmapDescriptor = this.getBitmapDescriptorByName(uri);
            if (this.iconBitmapDescriptor != null) {
                this.iconBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.getDrawableResourceByName(uri));
            }
            this.update();
        }
    }

    public MarkerOptions getMarkerOptions() {
        if (this.markerOptions == null) {
            this.markerOptions = this.createMarkerOptions();
        }
        return this.markerOptions;
    }

    public void addView(View child, int index) {
        super.addView(child, index);
        if (!(child instanceof AirMapCallout)) {
            this.hasCustomMarkerView = true;
        }
        this.update();
    }

    @Override
    public Object getFeature() {
        return this.marker;
    }

    @Override
    public void addToMap(GoogleMap map) {
        this.marker = map.addMarker(this.getMarkerOptions());
    }

    @Override
    public void removeFromMap(GoogleMap map) {
        this.marker.remove();
        this.marker = null;
    }

    private BitmapDescriptor getIcon() {
        if (this.hasCustomMarkerView) {
            if (this.iconBitmapDescriptor != null) {
                Bitmap viewBitmap = this.createDrawable();
                int width = Math.max(this.iconBitmap.getWidth(), viewBitmap.getWidth());
                int height = Math.max(this.iconBitmap.getHeight(), viewBitmap.getHeight());
                Bitmap combinedBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.iconBitmap.getConfig());
                Canvas canvas = new Canvas(combinedBitmap);
                canvas.drawBitmap(this.iconBitmap, 0.0f, 0.0f, null);
                canvas.drawBitmap(viewBitmap, 0.0f, 0.0f, null);
                return BitmapDescriptorFactory.fromBitmap((Bitmap)combinedBitmap);
            }
            return BitmapDescriptorFactory.fromBitmap((Bitmap)this.createDrawable());
        }
        if (this.iconBitmapDescriptor != null) {
            return this.iconBitmapDescriptor;
        }
        return BitmapDescriptorFactory.defaultMarker((float)this.markerHue);
    }

    private MarkerOptions createMarkerOptions() {
        MarkerOptions options = new MarkerOptions().position(this.position);
        if (this.anchorIsSet) {
            options.anchor(this.anchorX, this.anchorY);
        }
        if (this.calloutAnchorIsSet) {
            options.infoWindowAnchor(this.calloutAnchorX, this.calloutAnchorY);
        }
        options.title(this.title);
        options.snippet(this.snippet);
        options.rotation(this.rotation);
        options.flat(this.flat);
        options.draggable(this.draggable);
        options.zIndex((float)this.zIndex);
        options.alpha(this.opacity);
        options.icon(this.getIcon());
        return options;
    }

    public void update() {
        if (this.marker == null) {
            return;
        }
        this.marker.setIcon(this.getIcon());
        if (this.anchorIsSet) {
            this.marker.setAnchor(this.anchorX, this.anchorY);
        } else {
            this.marker.setAnchor(0.5f, 1.0f);
        }
        if (this.calloutAnchorIsSet) {
            this.marker.setInfoWindowAnchor(this.calloutAnchorX, this.calloutAnchorY);
        } else {
            this.marker.setInfoWindowAnchor(0.5f, 0.0f);
        }
    }

    public void update(int width, int height) {
        this.width = width;
        this.height = height;
        this.update();
    }

    private Bitmap createDrawable() {
        int width = this.width <= 0 ? 100 : this.width;
        int height = this.height <= 0 ? 100 : this.height;
        this.buildDrawingCache();
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        this.draw(canvas);
        return bitmap;
    }

    public void setCalloutView(AirMapCallout view) {
        this.calloutView = view;
    }

    public AirMapCallout getCalloutView() {
        return this.calloutView;
    }

    public View getCallout() {
        if (this.calloutView == null) {
            return null;
        }
        if (this.wrappedCalloutView == null) {
            this.wrapCalloutView();
        }
        if (this.calloutView.getTooltip()) {
            return this.wrappedCalloutView;
        }
        return null;
    }

    public View getInfoContents() {
        if (this.calloutView == null) {
            return null;
        }
        if (this.wrappedCalloutView == null) {
            this.wrapCalloutView();
        }
        if (this.calloutView.getTooltip()) {
            return null;
        }
        return this.wrappedCalloutView;
    }

    private void wrapCalloutView() {
        if (this.calloutView == null || this.calloutView.getChildCount() == 0) {
            return;
        }
        LinearLayout LL = new LinearLayout(this.context);
        LL.setOrientation(1);
        LL.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.calloutView.width, this.calloutView.height, 0.0f));
        LinearLayout LL2 = new LinearLayout(this.context);
        LL2.setOrientation(0);
        LL2.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.calloutView.width, this.calloutView.height, 0.0f));
        LL.addView((View)LL2);
        LL2.addView((View)this.calloutView);
        this.wrappedCalloutView = LL;
    }

    private int getDrawableResourceByName(String name) {
        return this.getResources().getIdentifier(name, "drawable", this.getContext().getPackageName());
    }

    private BitmapDescriptor getBitmapDescriptorByName(String name) {
        return BitmapDescriptorFactory.fromResource((int)this.getDrawableResourceByName(name));
    }
}

