/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import com.airbnb.android.react.maps.AirMapCallout;
import com.airbnb.android.react.maps.AirMapMarker;
import com.airbnb.android.react.maps.SizeReportingShadowNode;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.google.android.gms.maps.model.Marker;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class AirMapMarkerManager
extends ViewGroupManager<AirMapMarker> {
    private static final int SHOW_INFO_WINDOW = 1;
    private static final int HIDE_INFO_WINDOW = 2;

    public String getName() {
        return "AIRMapMarker";
    }

    public AirMapMarker createViewInstance(ThemedReactContext context) {
        return new AirMapMarker((Context)context);
    }

    @ReactProp(name="coordinate")
    public void setCoordinate(AirMapMarker view, ReadableMap map) {
        view.setCoordinate(map);
    }

    @ReactProp(name="title")
    public void setTitle(AirMapMarker view, String title) {
        view.setTitle(title);
    }

    @ReactProp(name="identifier")
    public void setIdentifier(AirMapMarker view, String identifier) {
        view.setIdentifier(identifier);
    }

    @ReactProp(name="description")
    public void setDescription(AirMapMarker view, String description) {
        view.setSnippet(description);
    }

    @ReactProp(name="anchor")
    public void setAnchor(AirMapMarker view, ReadableMap map) {
        double x = map != null && map.hasKey("x") ? map.getDouble("x") : 0.5;
        double y = map != null && map.hasKey("y") ? map.getDouble("y") : 1.0;
        view.setAnchor(x, y);
    }

    @ReactProp(name="calloutAnchor")
    public void setCalloutAnchor(AirMapMarker view, ReadableMap map) {
        double x = map != null && map.hasKey("x") ? map.getDouble("x") : 0.5;
        double y = map != null && map.hasKey("y") ? map.getDouble("y") : 0.0;
        view.setCalloutAnchor(x, y);
    }

    @ReactProp(name="image")
    public void setImage(AirMapMarker view, @Nullable String source) {
        view.setImage(source);
    }

    @ReactProp(name="pinColor", defaultInt=-65536, customType="Color")
    public void setPinColor(AirMapMarker view, int pinColor) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)pinColor, (float[])hsv);
        view.setMarkerHue(hsv[0]);
    }

    @ReactProp(name="rotation", defaultFloat=0.0f)
    public void setMarkerRotation(AirMapMarker view, float rotation) {
        view.setRotation(rotation);
    }

    @ReactProp(name="flat", defaultBoolean=false)
    public void setFlat(AirMapMarker view, boolean flat) {
        view.setFlat(flat);
    }

    @ReactProp(name="draggable", defaultBoolean=false)
    public void setDraggable(AirMapMarker view, boolean draggable) {
        view.setDraggable(draggable);
    }

    @ReactProp(name="zIndex", defaultFloat=0.0f)
    public void setZIndex(AirMapMarker view, float zIndex) {
        super.setZIndex((View)view, zIndex);
        int integerZIndex = Math.round(zIndex);
        view.setZIndex(integerZIndex);
    }

    @ReactProp(name="opacity", defaultFloat=1.0f)
    public void setOpacity(AirMapMarker view, float opacity) {
        super.setOpacity((View)view, opacity);
        view.setOpacity(opacity);
    }

    public void addView(AirMapMarker parent, View child, int index) {
        if (child instanceof AirMapCallout) {
            parent.setCalloutView((AirMapCallout)child);
        } else {
            super.addView((ViewGroup)parent, child, index);
            parent.update();
        }
    }

    public void removeViewAt(AirMapMarker parent, int index) {
        super.removeViewAt((ViewGroup)parent, index);
        parent.update();
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"showCallout", (Object)1, (Object)"hideCallout", (Object)2);
    }

    public void receiveCommand(AirMapMarker view, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                ((Marker)view.getFeature()).showInfoWindow();
                break;
            }
            case 2: {
                ((Marker)view.getFeature()).hideInfoWindow();
            }
        }
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        Map map = MapBuilder.of((Object)"onPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPress"), (Object)"onCalloutPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onCalloutPress"), (Object)"onDragStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragStart"), (Object)"onDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDrag"), (Object)"onDragEnd", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragEnd"));
        map.putAll(MapBuilder.of((Object)"onDragStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragStart"), (Object)"onDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDrag"), (Object)"onDragEnd", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragEnd")));
        return map;
    }

    public LayoutShadowNode createShadowNodeInstance() {
        return new SizeReportingShadowNode();
    }

    public void updateExtraData(AirMapMarker view, Object extraData) {
        HashMap data = (HashMap)extraData;
        float width = ((Float)data.get("width")).floatValue();
        float height = ((Float)data.get("height")).floatValue();
        view.update((int)width, (int)height);
    }
}

