/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import android.app.Activity;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Base64;
import android.util.DisplayMetrics;
import com.airbnb.android.react.maps.AirMapView;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIManagerModule;
import com.google.android.gms.maps.GoogleMap;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class AirMapModule
extends ReactContextBaseJavaModule {
    private static final String SNAPSHOT_RESULT_FILE = "file";
    private static final String SNAPSHOT_RESULT_BASE64 = "base64";
    private static final String SNAPSHOT_FORMAT_PNG = "png";
    private static final String SNAPSHOT_FORMAT_JPG = "jpg";

    public AirMapModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    public String getName() {
        return "AirMapModule";
    }

    public Map<String, Object> getConstants() {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        constants.put("legalNotice", "This license information is displayed in Settings > Google > Open Source on any device running Google Play services.");
        return constants;
    }

    public Activity getActivity() {
        return this.getCurrentActivity();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @ReactMethod
    public void takeSnapshot(final int tag, ReadableMap options, final Promise promise) {
        String format;
        final ReactApplicationContext context = this.getReactApplicationContext();
        String string = format = options.hasKey("format") ? options.getString("format") : SNAPSHOT_FORMAT_PNG;
        final Bitmap.CompressFormat compressFormat = format.equals(SNAPSHOT_FORMAT_PNG) ? Bitmap.CompressFormat.PNG : (format.equals(SNAPSHOT_FORMAT_JPG) ? Bitmap.CompressFormat.JPEG : null);
        final double quality = options.hasKey("quality") ? options.getDouble("quality") : 1.0;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        final Integer width = options.hasKey("width") ? (int)((double)displayMetrics.density * options.getDouble("width")) : 0;
        final Integer height = options.hasKey("height") ? (int)((double)displayMetrics.density * options.getDouble("height")) : 0;
        final String result = options.hasKey("result") ? options.getString("result") : SNAPSHOT_RESULT_FILE;
        UIManagerModule uiManager = (UIManagerModule)context.getNativeModule(UIManagerModule.class);
        uiManager.addUIBlock(new UIBlock(){

            public void execute(NativeViewHierarchyManager nvhm) {
                AirMapView view = (AirMapView)nvhm.resolveView(tag);
                if (view == null) {
                    promise.reject("AirMapView not found");
                    return;
                }
                if (view.map == null) {
                    promise.reject("AirMapView.map is not valid");
                    return;
                }
                view.map.snapshot(new GoogleMap.SnapshotReadyCallback(){

                    public void onSnapshotReady(@Nullable Bitmap snapshot) {
                        if (snapshot == null) {
                            promise.reject("Failed to generate bitmap, snapshot = null");
                            return;
                        }
                        if (width != 0 && height != 0 && (width.intValue() != snapshot.getWidth() || height.intValue() != snapshot.getHeight())) {
                            snapshot = Bitmap.createScaledBitmap((Bitmap)snapshot, (int)width, (int)height, (boolean)true);
                        }
                        if (result.equals(AirMapModule.SNAPSHOT_RESULT_FILE)) {
                            FileOutputStream outputStream;
                            File tempFile;
                            try {
                                tempFile = File.createTempFile("AirMapSnapshot", "." + format, context.getCacheDir());
                                outputStream = new FileOutputStream(tempFile);
                            }
                            catch (Exception e) {
                                promise.reject((Throwable)e);
                                return;
                            }
                            snapshot.compress(compressFormat, (int)(100.0 * quality), (OutputStream)outputStream);
                            AirMapModule.closeQuietly(outputStream);
                            String uri = Uri.fromFile((File)tempFile).toString();
                            promise.resolve((Object)uri);
                        } else if (result.equals(AirMapModule.SNAPSHOT_RESULT_BASE64)) {
                            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                            snapshot.compress(compressFormat, (int)(100.0 * quality), (OutputStream)outputStream);
                            AirMapModule.closeQuietly(outputStream);
                            byte[] bytes = outputStream.toByteArray();
                            String data = Base64.encodeToString((byte[])bytes, (int)2);
                            promise.resolve((Object)data);
                        }
                    }
                });
            }
        });
    }
}

