/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.airbnb.android.react.maps.AirMapPolyline;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.annotations.ReactProp;
import java.util.Map;
import javax.annotation.Nullable;

public class AirMapPolylineManager
extends ViewGroupManager<AirMapPolyline> {
    private final DisplayMetrics metrics;

    public AirMapPolylineManager(ReactApplicationContext reactContext) {
        if (Build.VERSION.SDK_INT >= 17) {
            this.metrics = new DisplayMetrics();
            ((WindowManager)reactContext.getSystemService("window")).getDefaultDisplay().getRealMetrics(this.metrics);
        } else {
            this.metrics = reactContext.getResources().getDisplayMetrics();
        }
    }

    public String getName() {
        return "AIRMapPolyline";
    }

    public AirMapPolyline createViewInstance(ThemedReactContext context) {
        return new AirMapPolyline((Context)context);
    }

    @ReactProp(name="coordinates")
    public void setCoordinate(AirMapPolyline view, ReadableArray coordinates) {
        view.setCoordinates(coordinates);
    }

    @ReactProp(name="strokeWidth", defaultFloat=1.0f)
    public void setStrokeWidth(AirMapPolyline view, float widthInPoints) {
        float widthInScreenPx = this.metrics.density * widthInPoints;
        view.setWidth(widthInScreenPx);
    }

    @ReactProp(name="strokeColor", defaultInt=-65536, customType="Color")
    public void setStrokeColor(AirMapPolyline view, int color) {
        view.setColor(color);
    }

    @ReactProp(name="geodesic", defaultBoolean=false)
    public void setGeodesic(AirMapPolyline view, boolean geodesic) {
        view.setGeodesic(geodesic);
    }

    @ReactProp(name="zIndex", defaultFloat=1.0f)
    public void setZIndex(AirMapPolyline view, float zIndex) {
        view.setZIndex(zIndex);
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of((Object)"onPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPress"));
    }
}

