/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Handler;
import android.support.v4.content.PermissionChecker;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.MotionEventCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.airbnb.android.react.maps.AirMapCallout;
import com.airbnb.android.react.maps.AirMapCircle;
import com.airbnb.android.react.maps.AirMapFeature;
import com.airbnb.android.react.maps.AirMapManager;
import com.airbnb.android.react.maps.AirMapMarker;
import com.airbnb.android.react.maps.AirMapPolygon;
import com.airbnb.android.react.maps.AirMapPolyline;
import com.airbnb.android.react.maps.AirMapUrlTile;
import com.airbnb.android.react.maps.LatLngBoundsUtils;
import com.airbnb.android.react.maps.RegionChangeEvent;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapView;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.VisibleRegion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AirMapView
extends MapView
implements GoogleMap.InfoWindowAdapter,
GoogleMap.OnMarkerDragListener,
OnMapReadyCallback {
    public GoogleMap map;
    private ProgressBar mapLoadingProgressBar;
    private RelativeLayout mapLoadingLayout;
    private ImageView cacheImageView;
    private Boolean isMapLoaded = false;
    private Integer loadingBackgroundColor = null;
    private Integer loadingIndicatorColor = null;
    private final int baseMapPadding = 50;
    private LatLngBounds boundsToMove;
    private boolean showUserLocation = false;
    private boolean isMonitoringRegion = false;
    private boolean isTouchDown = false;
    private boolean handlePanDrag = false;
    private boolean moveOnMarkerPress = true;
    private boolean cacheEnabled = false;
    private boolean initialRegionSet = false;
    private static final String[] PERMISSIONS = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    private final List<AirMapFeature> features = new ArrayList<AirMapFeature>();
    private final Map<Marker, AirMapMarker> markerMap = new HashMap<Marker, AirMapMarker>();
    private final Map<Polyline, AirMapPolyline> polylineMap = new HashMap<Polyline, AirMapPolyline>();
    private final Map<Polygon, AirMapPolygon> polygonMap = new HashMap<Polygon, AirMapPolygon>();
    private final ScaleGestureDetector scaleDetector;
    private final GestureDetectorCompat gestureDetector;
    private final AirMapManager manager;
    private LifecycleEventListener lifecycleListener;
    private boolean paused = false;
    private boolean destroyed = false;
    private final ThemedReactContext context;
    private final EventDispatcher eventDispatcher;
    private LatLngBounds lastBoundsEmitted;
    Handler timerHandler = new Handler();
    Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
            if (AirMapView.this.map != null) {
                LatLngBounds bounds;
                Projection projection = AirMapView.this.map.getProjection();
                VisibleRegion region = projection != null ? projection.getVisibleRegion() : null;
                LatLngBounds latLngBounds = bounds = region != null ? region.latLngBounds : null;
                if (bounds != null && (AirMapView.this.lastBoundsEmitted == null || LatLngBoundsUtils.BoundsAreDifferent(bounds, AirMapView.this.lastBoundsEmitted))) {
                    LatLng center = AirMapView.this.map.getCameraPosition().target;
                    AirMapView.this.lastBoundsEmitted = bounds;
                    AirMapView.this.eventDispatcher.dispatchEvent((Event)new RegionChangeEvent(AirMapView.this.getId(), bounds, center, true));
                }
            }
            AirMapView.this.timerHandler.postDelayed((Runnable)this, 100L);
        }
    };

    private static boolean contextHasBug(Context context) {
        return context == null || context.getResources() == null || context.getResources().getConfiguration() == null;
    }

    private static Context getNonBuggyContext(ThemedReactContext reactContext, ReactApplicationContext appContext) {
        ThemedReactContext superContext = reactContext;
        if (!AirMapView.contextHasBug((Context)appContext.getCurrentActivity())) {
            superContext = appContext.getCurrentActivity();
        } else if (AirMapView.contextHasBug((Context)superContext)) {
            if (!AirMapView.contextHasBug((Context)reactContext.getCurrentActivity())) {
                superContext = reactContext.getCurrentActivity();
            } else if (!AirMapView.contextHasBug(reactContext.getApplicationContext())) {
                superContext = reactContext.getApplicationContext();
            }
        }
        return superContext;
    }

    public AirMapView(ThemedReactContext reactContext, ReactApplicationContext appContext, AirMapManager manager, GoogleMapOptions googleMapOptions) {
        super(AirMapView.getNonBuggyContext(reactContext, appContext), googleMapOptions);
        this.manager = manager;
        this.context = reactContext;
        super.onCreate(null);
        super.onResume();
        super.getMapAsync((OnMapReadyCallback)this);
        final AirMapView view = this;
        this.scaleDetector = new ScaleGestureDetector((Context)reactContext, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScaleBegin(ScaleGestureDetector detector) {
                view.startMonitoringRegion();
                return true;
            }
        });
        this.gestureDetector = new GestureDetectorCompat((Context)reactContext, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                view.startMonitoringRegion();
                return false;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (AirMapView.this.handlePanDrag) {
                    AirMapView.this.onPanDrag(e2);
                }
                view.startMonitoringRegion();
                return false;
            }
        });
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (!AirMapView.this.paused) {
                    AirMapView.this.cacheView();
                }
            }
        });
        this.eventDispatcher = ((UIManagerModule)reactContext.getNativeModule(UIManagerModule.class)).getEventDispatcher();
    }

    public void onMapReady(final GoogleMap map) {
        if (this.destroyed) {
            return;
        }
        this.map = map;
        this.map.setInfoWindowAdapter((GoogleMap.InfoWindowAdapter)this);
        this.map.setOnMarkerDragListener((GoogleMap.OnMarkerDragListener)this);
        this.manager.pushEvent(this.context, (View)this, "onMapReady", (WritableMap)new WritableNativeMap());
        final AirMapView view = this;
        map.setOnMarkerClickListener(new GoogleMap.OnMarkerClickListener(){

            public boolean onMarkerClick(Marker marker) {
                AirMapMarker airMapMarker = (AirMapMarker)((Object)AirMapView.this.markerMap.get(marker));
                WritableMap event = AirMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "marker-press");
                event.putString("id", airMapMarker.getIdentifier());
                AirMapView.this.manager.pushEvent(AirMapView.this.context, (View)view, "onMarkerPress", event);
                event = AirMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "marker-press");
                event.putString("id", airMapMarker.getIdentifier());
                AirMapView.this.manager.pushEvent(AirMapView.this.context, (View)AirMapView.this.markerMap.get(marker), "onPress", event);
                if (view.moveOnMarkerPress) {
                    return false;
                }
                marker.showInfoWindow();
                return true;
            }
        });
        map.setOnPolygonClickListener(new GoogleMap.OnPolygonClickListener(){

            public void onPolygonClick(Polygon polygon) {
                WritableMap event = AirMapView.this.makeClickEventData((LatLng)polygon.getPoints().get(0));
                event.putString("action", "polygon-press");
                AirMapView.this.manager.pushEvent(AirMapView.this.context, (View)AirMapView.this.polygonMap.get(polygon), "onPress", event);
            }
        });
        map.setOnPolylineClickListener(new GoogleMap.OnPolylineClickListener(){

            public void onPolylineClick(Polyline polyline) {
                WritableMap event = AirMapView.this.makeClickEventData((LatLng)polyline.getPoints().get(0));
                event.putString("action", "polyline-press");
                AirMapView.this.manager.pushEvent(AirMapView.this.context, (View)AirMapView.this.polylineMap.get(polyline), "onPress", event);
            }
        });
        map.setOnInfoWindowClickListener(new GoogleMap.OnInfoWindowClickListener(){

            public void onInfoWindowClick(Marker marker) {
                WritableMap event = AirMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "callout-press");
                AirMapView.this.manager.pushEvent(AirMapView.this.context, (View)view, "onCalloutPress", event);
                event = AirMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "callout-press");
                AirMapMarker markerView = (AirMapMarker)((Object)AirMapView.this.markerMap.get(marker));
                AirMapView.this.manager.pushEvent(AirMapView.this.context, (View)markerView, "onCalloutPress", event);
                event = AirMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "callout-press");
                AirMapCallout infoWindow = markerView.getCalloutView();
                if (infoWindow != null) {
                    AirMapView.this.manager.pushEvent(AirMapView.this.context, (View)infoWindow, "onPress", event);
                }
            }
        });
        map.setOnMapClickListener(new GoogleMap.OnMapClickListener(){

            public void onMapClick(LatLng point) {
                WritableMap event = AirMapView.this.makeClickEventData(point);
                event.putString("action", "press");
                AirMapView.this.manager.pushEvent(AirMapView.this.context, (View)view, "onPress", event);
            }
        });
        map.setOnMapLongClickListener(new GoogleMap.OnMapLongClickListener(){

            public void onMapLongClick(LatLng point) {
                WritableMap event = AirMapView.this.makeClickEventData(point);
                event.putString("action", "long-press");
                AirMapView.this.manager.pushEvent(AirMapView.this.context, (View)view, "onLongPress", AirMapView.this.makeClickEventData(point));
            }
        });
        map.setOnCameraChangeListener(new GoogleMap.OnCameraChangeListener(){

            public void onCameraChange(CameraPosition position) {
                LatLngBounds bounds = map.getProjection().getVisibleRegion().latLngBounds;
                LatLng center = position.target;
                AirMapView.this.lastBoundsEmitted = bounds;
                AirMapView.this.eventDispatcher.dispatchEvent((Event)new RegionChangeEvent(AirMapView.this.getId(), bounds, center, AirMapView.this.isTouchDown));
                view.stopMonitoringRegion();
            }
        });
        map.setOnMapLoadedCallback(new GoogleMap.OnMapLoadedCallback(){

            public void onMapLoaded() {
                AirMapView.this.isMapLoaded = true;
                AirMapView.this.cacheView();
            }
        });
        this.lifecycleListener = new LifecycleEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onHostResume() {
                if (AirMapView.this.hasPermissions()) {
                    map.setMyLocationEnabled(AirMapView.this.showUserLocation);
                }
                AirMapView airMapView = AirMapView.this;
                synchronized (airMapView) {
                    if (!AirMapView.this.destroyed) {
                        AirMapView.this.onResume();
                    }
                    AirMapView.this.paused = false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onHostPause() {
                if (AirMapView.this.hasPermissions()) {
                    map.setMyLocationEnabled(false);
                }
                AirMapView airMapView = AirMapView.this;
                synchronized (airMapView) {
                    if (!AirMapView.this.destroyed) {
                        AirMapView.this.onPause();
                    }
                    AirMapView.this.paused = true;
                }
            }

            public void onHostDestroy() {
                AirMapView.this.doDestroy();
            }
        };
        this.context.addLifecycleEventListener(this.lifecycleListener);
    }

    private boolean hasPermissions() {
        return PermissionChecker.checkSelfPermission((Context)this.getContext(), (String)PERMISSIONS[0]) == 0 || PermissionChecker.checkSelfPermission((Context)this.getContext(), (String)PERMISSIONS[1]) == 0;
    }

    public synchronized void doDestroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (this.lifecycleListener != null && this.context != null) {
            this.context.removeLifecycleEventListener(this.lifecycleListener);
            this.lifecycleListener = null;
        }
        if (!this.paused) {
            this.onPause();
            this.paused = true;
        }
        this.onDestroy();
    }

    public void setInitialRegion(ReadableMap initialRegion) {
        if (!this.initialRegionSet && initialRegion != null) {
            this.setRegion(initialRegion);
            this.initialRegionSet = true;
        }
    }

    public void setRegion(ReadableMap region) {
        if (region == null) {
            return;
        }
        Double lng = region.getDouble("longitude");
        Double lat = region.getDouble("latitude");
        Double lngDelta = region.getDouble("longitudeDelta");
        Double latDelta = region.getDouble("latitudeDelta");
        LatLngBounds bounds = new LatLngBounds(new LatLng(lat - latDelta / 2.0, lng - lngDelta / 2.0), new LatLng(lat + latDelta / 2.0, lng + lngDelta / 2.0));
        if (super.getHeight() <= 0 || super.getWidth() <= 0) {
            this.map.moveCamera(CameraUpdateFactory.newLatLngZoom((LatLng)new LatLng(lat.doubleValue(), lng.doubleValue()), (float)10.0f));
            this.boundsToMove = bounds;
        } else {
            this.map.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)0));
            this.boundsToMove = null;
        }
    }

    public void setShowsUserLocation(boolean showUserLocation) {
        this.showUserLocation = showUserLocation;
        if (this.hasPermissions()) {
            this.map.setMyLocationEnabled(showUserLocation);
        }
    }

    public void setShowsMyLocationButton(boolean showMyLocationButton) {
        if (this.hasPermissions()) {
            this.map.getUiSettings().setMyLocationButtonEnabled(showMyLocationButton);
        }
    }

    public void setToolbarEnabled(boolean toolbarEnabled) {
        if (this.hasPermissions()) {
            this.map.getUiSettings().setMapToolbarEnabled(toolbarEnabled);
        }
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        this.cacheView();
    }

    public void enableMapLoading(boolean loadingEnabled) {
        if (loadingEnabled && !this.isMapLoaded.booleanValue()) {
            this.getMapLoadingLayoutView().setVisibility(0);
        }
    }

    public void setMoveOnMarkerPress(boolean moveOnPress) {
        this.moveOnMarkerPress = moveOnPress;
    }

    public void setLoadingBackgroundColor(Integer loadingBackgroundColor) {
        this.loadingBackgroundColor = loadingBackgroundColor;
        if (this.mapLoadingLayout != null) {
            if (loadingBackgroundColor == null) {
                this.mapLoadingLayout.setBackgroundColor(-1);
            } else {
                this.mapLoadingLayout.setBackgroundColor(this.loadingBackgroundColor.intValue());
            }
        }
    }

    public void setLoadingIndicatorColor(Integer loadingIndicatorColor) {
        this.loadingIndicatorColor = loadingIndicatorColor;
        if (this.mapLoadingProgressBar != null) {
            Integer color = loadingIndicatorColor;
            if (color == null) {
                color = Color.parseColor((String)"#606060");
            }
            if (Build.VERSION.SDK_INT >= 21) {
                ColorStateList progressTintList = ColorStateList.valueOf((int)loadingIndicatorColor);
                ColorStateList secondaryProgressTintList = ColorStateList.valueOf((int)loadingIndicatorColor);
                ColorStateList indeterminateTintList = ColorStateList.valueOf((int)loadingIndicatorColor);
                this.mapLoadingProgressBar.setProgressTintList(progressTintList);
                this.mapLoadingProgressBar.setSecondaryProgressTintList(secondaryProgressTintList);
                this.mapLoadingProgressBar.setIndeterminateTintList(indeterminateTintList);
            } else {
                PorterDuff.Mode mode = PorterDuff.Mode.SRC_IN;
                if (Build.VERSION.SDK_INT <= 10) {
                    mode = PorterDuff.Mode.MULTIPLY;
                }
                if (this.mapLoadingProgressBar.getIndeterminateDrawable() != null) {
                    this.mapLoadingProgressBar.getIndeterminateDrawable().setColorFilter(color.intValue(), mode);
                }
                if (this.mapLoadingProgressBar.getProgressDrawable() != null) {
                    this.mapLoadingProgressBar.getProgressDrawable().setColorFilter(color.intValue(), mode);
                }
            }
        }
    }

    public void setHandlePanDrag(boolean handlePanDrag) {
        this.handlePanDrag = handlePanDrag;
    }

    public void addFeature(View child, int index) {
        if (child instanceof AirMapMarker) {
            AirMapMarker annotation = (AirMapMarker)child;
            annotation.addToMap(this.map);
            this.features.add(index, annotation);
            Marker marker = (Marker)annotation.getFeature();
            this.markerMap.put(marker, annotation);
        } else if (child instanceof AirMapPolyline) {
            AirMapPolyline polylineView = (AirMapPolyline)child;
            polylineView.addToMap(this.map);
            this.features.add(index, polylineView);
            Polyline polyline = (Polyline)polylineView.getFeature();
            this.polylineMap.put(polyline, polylineView);
        } else if (child instanceof AirMapPolygon) {
            AirMapPolygon polygonView = (AirMapPolygon)child;
            polygonView.addToMap(this.map);
            this.features.add(index, polygonView);
            Polygon polygon = (Polygon)polygonView.getFeature();
            this.polygonMap.put(polygon, polygonView);
        } else if (child instanceof AirMapCircle) {
            AirMapCircle circleView = (AirMapCircle)child;
            circleView.addToMap(this.map);
            this.features.add(index, circleView);
        } else if (child instanceof AirMapUrlTile) {
            AirMapUrlTile urlTileView = (AirMapUrlTile)child;
            urlTileView.addToMap(this.map);
            this.features.add(index, urlTileView);
        } else {
            ViewGroup children = (ViewGroup)child;
            for (int i = 0; i < children.getChildCount(); ++i) {
                this.addFeature(children.getChildAt(i), index);
            }
        }
    }

    public int getFeatureCount() {
        return this.features.size();
    }

    public View getFeatureAt(int index) {
        return (View)this.features.get(index);
    }

    public void removeFeatureAt(int index) {
        AirMapFeature feature = this.features.remove(index);
        if (feature instanceof AirMapMarker) {
            this.markerMap.remove(feature.getFeature());
        }
        feature.removeFromMap(this.map);
    }

    public WritableMap makeClickEventData(LatLng point) {
        WritableNativeMap event = new WritableNativeMap();
        WritableNativeMap coordinate = new WritableNativeMap();
        coordinate.putDouble("latitude", point.latitude);
        coordinate.putDouble("longitude", point.longitude);
        event.putMap("coordinate", (WritableMap)coordinate);
        Projection projection = this.map.getProjection();
        Point screenPoint = projection.toScreenLocation(point);
        WritableNativeMap position = new WritableNativeMap();
        position.putDouble("x", (double)screenPoint.x);
        position.putDouble("y", (double)screenPoint.y);
        event.putMap("position", (WritableMap)position);
        return event;
    }

    public void updateExtraData(Object extraData) {
        if (this.boundsToMove != null) {
            int height;
            HashMap data = (HashMap)extraData;
            int width = data.get("width") == null ? 0 : ((Float)data.get("width")).intValue();
            int n = height = data.get("height") == null ? 0 : ((Float)data.get("height")).intValue();
            if (width <= 0 || height <= 0) {
                this.map.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)this.boundsToMove, (int)0));
            } else {
                this.map.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)this.boundsToMove, (int)width, (int)height, (int)0));
            }
            this.boundsToMove = null;
        }
    }

    public void animateToRegion(LatLngBounds bounds, int duration) {
        if (this.map != null) {
            this.startMonitoringRegion();
            this.map.animateCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)0), duration, null);
        }
    }

    public void animateToViewingAngle(float angle, int duration) {
        if (this.map != null) {
            this.startMonitoringRegion();
            CameraPosition cameraPosition = new CameraPosition.Builder(this.map.getCameraPosition()).tilt(angle).build();
            this.map.animateCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)cameraPosition), duration, null);
        }
    }

    public void animateToBearing(float bearing, int duration) {
        if (this.map != null) {
            this.startMonitoringRegion();
            CameraPosition cameraPosition = new CameraPosition.Builder(this.map.getCameraPosition()).bearing(bearing).build();
            this.map.animateCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)cameraPosition), duration, null);
        }
    }

    public void animateToCoordinate(LatLng coordinate, int duration) {
        if (this.map != null) {
            this.startMonitoringRegion();
            this.map.animateCamera(CameraUpdateFactory.newLatLng((LatLng)coordinate), duration, null);
        }
    }

    public void fitToElements(boolean animated) {
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        boolean addedPosition = false;
        for (AirMapFeature feature : this.features) {
            if (!(feature instanceof AirMapMarker)) continue;
            Marker marker = (Marker)feature.getFeature();
            builder.include(marker.getPosition());
            addedPosition = true;
        }
        if (addedPosition) {
            LatLngBounds bounds = builder.build();
            CameraUpdate cu = CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)50);
            if (animated) {
                this.startMonitoringRegion();
                this.map.animateCamera(cu);
            } else {
                this.map.moveCamera(cu);
            }
        }
    }

    public void fitToSuppliedMarkers(ReadableArray markerIDsArray, boolean animated) {
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        String[] markerIDs = new String[markerIDsArray.size()];
        for (int i = 0; i < markerIDsArray.size(); ++i) {
            markerIDs[i] = markerIDsArray.getString(i);
        }
        boolean addedPosition = false;
        List<String> markerIDList = Arrays.asList(markerIDs);
        for (AirMapFeature feature : this.features) {
            if (!(feature instanceof AirMapMarker)) continue;
            String identifier = ((AirMapMarker)feature).getIdentifier();
            Marker marker = (Marker)feature.getFeature();
            if (!markerIDList.contains(identifier)) continue;
            builder.include(marker.getPosition());
            addedPosition = true;
        }
        if (addedPosition) {
            LatLngBounds bounds = builder.build();
            CameraUpdate cu = CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)50);
            if (animated) {
                this.startMonitoringRegion();
                this.map.animateCamera(cu);
            } else {
                this.map.moveCamera(cu);
            }
        }
    }

    public void fitToCoordinates(ReadableArray coordinatesArray, ReadableMap edgePadding, boolean animated) {
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        for (int i = 0; i < coordinatesArray.size(); ++i) {
            ReadableMap latLng = coordinatesArray.getMap(i);
            Double lat = latLng.getDouble("latitude");
            Double lng = latLng.getDouble("longitude");
            builder.include(new LatLng(lat.doubleValue(), lng.doubleValue()));
        }
        LatLngBounds bounds = builder.build();
        CameraUpdate cu = CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)50);
        if (edgePadding != null) {
            this.map.setPadding(edgePadding.getInt("left"), edgePadding.getInt("top"), edgePadding.getInt("right"), edgePadding.getInt("bottom"));
        }
        if (animated) {
            this.startMonitoringRegion();
            this.map.animateCamera(cu);
        } else {
            this.map.moveCamera(cu);
        }
        this.map.setPadding(0, 0, 0, 0);
    }

    public View getInfoWindow(Marker marker) {
        AirMapMarker markerView = this.markerMap.get(marker);
        return markerView.getCallout();
    }

    public View getInfoContents(Marker marker) {
        AirMapMarker markerView = this.markerMap.get(marker);
        return markerView.getInfoContents();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.scaleDetector.onTouchEvent(ev);
        this.gestureDetector.onTouchEvent(ev);
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.getParent().requestDisallowInterceptTouchEvent(this.map != null && this.map.getUiSettings().isScrollGesturesEnabled());
                this.isTouchDown = true;
                break;
            }
            case 2: {
                this.startMonitoringRegion();
                break;
            }
            case 1: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.isTouchDown = false;
            }
        }
        super.dispatchTouchEvent(ev);
        return true;
    }

    public void startMonitoringRegion() {
        if (this.map == null || this.isMonitoringRegion) {
            return;
        }
        this.timerHandler.postDelayed(this.timerRunnable, 100L);
        this.isMonitoringRegion = true;
    }

    public void stopMonitoringRegion() {
        if (this.map == null || !this.isMonitoringRegion) {
            return;
        }
        this.timerHandler.removeCallbacks(this.timerRunnable);
        this.isMonitoringRegion = false;
    }

    public void onMarkerDragStart(Marker marker) {
        WritableMap event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent(this.context, (View)this, "onMarkerDragStart", event);
        AirMapMarker markerView = this.markerMap.get(marker);
        event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent(this.context, (View)markerView, "onDragStart", event);
    }

    public void onMarkerDrag(Marker marker) {
        WritableMap event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent(this.context, (View)this, "onMarkerDrag", event);
        AirMapMarker markerView = this.markerMap.get(marker);
        event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent(this.context, (View)markerView, "onDrag", event);
    }

    public void onMarkerDragEnd(Marker marker) {
        WritableMap event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent(this.context, (View)this, "onMarkerDragEnd", event);
        AirMapMarker markerView = this.markerMap.get(marker);
        event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent(this.context, (View)markerView, "onDragEnd", event);
    }

    private ProgressBar getMapLoadingProgressBar() {
        if (this.mapLoadingProgressBar == null) {
            this.mapLoadingProgressBar = new ProgressBar(this.getContext());
            this.mapLoadingProgressBar.setIndeterminate(true);
        }
        if (this.loadingIndicatorColor != null) {
            this.setLoadingIndicatorColor(this.loadingIndicatorColor);
        }
        return this.mapLoadingProgressBar;
    }

    private RelativeLayout getMapLoadingLayoutView() {
        if (this.mapLoadingLayout == null) {
            this.mapLoadingLayout = new RelativeLayout(this.getContext());
            this.mapLoadingLayout.setBackgroundColor(-3355444);
            this.addView((View)this.mapLoadingLayout, new ViewGroup.LayoutParams(-1, -1));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
            params.addRule(13);
            this.mapLoadingLayout.addView((View)this.getMapLoadingProgressBar(), (ViewGroup.LayoutParams)params);
            this.mapLoadingLayout.setVisibility(4);
        }
        this.setLoadingBackgroundColor(this.loadingBackgroundColor);
        return this.mapLoadingLayout;
    }

    private ImageView getCacheImageView() {
        if (this.cacheImageView == null) {
            this.cacheImageView = new ImageView(this.getContext());
            this.addView((View)this.cacheImageView, new ViewGroup.LayoutParams(-1, -1));
            this.cacheImageView.setVisibility(4);
        }
        return this.cacheImageView;
    }

    private void removeCacheImageView() {
        if (this.cacheImageView != null) {
            ((ViewGroup)this.cacheImageView.getParent()).removeView((View)this.cacheImageView);
            this.cacheImageView = null;
        }
    }

    private void removeMapLoadingProgressBar() {
        if (this.mapLoadingProgressBar != null) {
            ((ViewGroup)this.mapLoadingProgressBar.getParent()).removeView((View)this.mapLoadingProgressBar);
            this.mapLoadingProgressBar = null;
        }
    }

    private void removeMapLoadingLayoutView() {
        this.removeMapLoadingProgressBar();
        if (this.mapLoadingLayout != null) {
            ((ViewGroup)this.mapLoadingLayout.getParent()).removeView((View)this.mapLoadingLayout);
            this.mapLoadingLayout = null;
        }
    }

    private void cacheView() {
        if (this.cacheEnabled) {
            final ImageView cacheImageView = this.getCacheImageView();
            final RelativeLayout mapLoadingLayout = this.getMapLoadingLayoutView();
            cacheImageView.setVisibility(4);
            mapLoadingLayout.setVisibility(0);
            if (this.isMapLoaded.booleanValue()) {
                this.map.snapshot(new GoogleMap.SnapshotReadyCallback(){

                    public void onSnapshotReady(Bitmap bitmap) {
                        cacheImageView.setImageBitmap(bitmap);
                        cacheImageView.setVisibility(0);
                        mapLoadingLayout.setVisibility(4);
                    }
                });
            }
        } else {
            this.removeCacheImageView();
            if (this.isMapLoaded.booleanValue()) {
                this.removeMapLoadingLayoutView();
            }
        }
    }

    public void onPanDrag(MotionEvent ev) {
        Point point = new Point((int)ev.getX(), (int)ev.getY());
        LatLng coords = this.map.getProjection().fromScreenLocation(point);
        WritableMap event = this.makeClickEventData(coords);
        this.manager.pushEvent(this.context, (View)this, "onPanDrag", event);
    }
}

