/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.android.react.maps;

import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;

public class LatLngBoundsUtils {
    public static boolean BoundsAreDifferent(LatLngBounds a, LatLngBounds b) {
        LatLng centerA = a.getCenter();
        double latA = centerA.latitude;
        double lngA = centerA.longitude;
        double latDeltaA = a.northeast.latitude - a.southwest.latitude;
        double lngDeltaA = a.northeast.longitude - a.southwest.longitude;
        LatLng centerB = b.getCenter();
        double latB = centerB.latitude;
        double lngB = centerB.longitude;
        double latDeltaB = b.northeast.latitude - b.southwest.latitude;
        double lngDeltaB = b.northeast.longitude - b.southwest.longitude;
        double latEps = LatLngBoundsUtils.LatitudeEpsilon(a, b);
        double lngEps = LatLngBoundsUtils.LongitudeEpsilon(a, b);
        return LatLngBoundsUtils.different(latA, latB, latEps) || LatLngBoundsUtils.different(lngA, lngB, lngEps) || LatLngBoundsUtils.different(latDeltaA, latDeltaB, latEps) || LatLngBoundsUtils.different(lngDeltaA, lngDeltaB, lngEps);
    }

    private static boolean different(double a, double b, double epsilon) {
        return Math.abs(a - b) > epsilon;
    }

    private static double LatitudeEpsilon(LatLngBounds a, LatLngBounds b) {
        double sizeA = a.northeast.latitude - a.southwest.latitude;
        double sizeB = b.northeast.latitude - b.southwest.latitude;
        double size = Math.min(Math.abs(sizeA), Math.abs(sizeB));
        return size / 2560.0;
    }

    private static double LongitudeEpsilon(LatLngBounds a, LatLngBounds b) {
        double sizeA = a.northeast.longitude - a.southwest.longitude;
        double sizeB = b.northeast.longitude - b.southwest.longitude;
        double size = Math.min(Math.abs(sizeA), Math.abs(sizeB));
        return size / 2560.0;
    }
}

