/*
 * Decompiled with CFR 0.152.
 */
package io.autodidact.mathjaxprovider;

import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import io.autodidact.mathjaxprovider.MathJaxProvider;

public class JavaScriptUtility {
    private WebView mWebView;

    public JavaScriptUtility(WebView webView) {
        this.mWebView = webView;
    }

    public void loadScript(String script) {
        this.mWebView.evaluateJavascript(script, null);
    }

    private String getSizeJSFormula() {
        return "window.WebViewJS.getSize(document.querySelector('body').firstElementChild.getBoundingClientRect().width, document.querySelector('body').offsetHeight);";
    }

    private String setFontColorJSFormula(String fontColor) {
        return "document.querySelector('body').style.color = \"" + fontColor + "\";";
    }

    private String resizeObserverScript() {
        return "window.resizeObserver = new ResizeObserver(entries => {\n" + this.getSizeJSFormula() + "});\nresizeObserver.observe(document.querySelector(\"body\"));\nresizeObserver.observe(document.querySelector(\"body\").firstElementChild);";
    }

    private String setStyleString(String key, String value, String elementProvider) {
        return elementProvider + ".style." + key + " = \"" + value + "\";";
    }

    public void measureWebView() {
        this.loadScript(this.getSizeJSFormula());
    }

    public void runSetFontColorJS(String fontColor) {
        this.loadScript(this.setFontColorJSFormula(fontColor));
    }

    public void addResizeObserver() {
        this.loadScript(this.getSizeJSFormula());
    }

    public static class WebViewBridge {
        MathJaxProvider mContext;

        public WebViewBridge(MathJaxProvider view) {
            this.mContext = view;
        }

        @JavascriptInterface
        public void postMessage(final String message) {
            this.mContext.post(new Runnable(){

                @Override
                public void run() {
                    WebViewBridge.this.mContext.onMessage(message);
                }
            });
        }
    }
}

