/*
 * Decompiled with CFR 0.152.
 */
package io.autodidact.rnmathview;

import android.view.View;
import android.widget.ImageView;
import com.caverock.androidsvg.PreserveAspectRatio;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import io.autodidact.rnmathview.SVGMathView;
import io.autodidact.rnmathview.SVGShadowNode;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RNMathViewManager
extends SimpleViewManager<SVGMathView> {
    public static final String PROPS_SVG_STRING = "svg";
    public static final String PROPS_MATH = "math";
    public static final String PROPS_COLOR = "color";
    public static final String PROPS_CONFIG = "config";
    public static final String PROPS_CSS = "css";
    public static final String PROPS_PRESERVE_ASPECT_RATIO = "preserveAspectRatio";
    public static final String PROPS_SCALE_TYPE = "scaleType";
    private ReactApplicationContext context;

    public RNMathViewManager() {
    }

    public RNMathViewManager(ReactApplicationContext context) {
        this.context = context;
    }

    public String getName() {
        return "RNMathView";
    }

    public LayoutShadowNode createShadowNodeInstance() {
        return new SVGShadowNode();
    }

    public Class getShadowNodeClass() {
        return SVGShadowNode.class;
    }

    protected SVGMathView createViewInstance(ThemedReactContext context) {
        SVGMathView view = new SVGMathView(context);
        return view;
    }

    protected void onAfterUpdateTransaction(@Nonnull SVGMathView view) {
        super.onAfterUpdateTransaction((View)view);
        view.updateView();
    }

    @ReactProp(name="svg")
    public void setSVG(SVGMathView viewContainer, String value) {
        viewContainer.setSVGString(value);
    }

    @ReactProp(name="math")
    public void setMath(SVGMathView viewContainer, String value) {
    }

    @ReactProp(name="color", customType="Color")
    public void setColor(SVGMathView viewContainer, @Nullable Integer color) {
        if (color != null) {
            viewContainer.setColor(color);
        }
    }

    @ReactProp(name="config")
    public void setConfig(SVGMathView viewContainer, @Nullable ReadableMap config) {
        if (config == null) {
            return;
        }
        if (config.hasKey("ex")) {
            viewContainer.getSVGAttributes().setEX(config.getInt("ex"));
        }
    }

    @ReactProp(name="css")
    public void setCSS(SVGMathView viewContainer, String css) {
        viewContainer.setCSS(css);
    }

    @ReactProp(name="preserveAspectRatio")
    public void setPreserveAspectRatio(SVGMathView viewContainer, String value) {
        viewContainer.setPreserveAspectRatio(value);
    }

    @ReactProp(name="scaleType")
    public void setScaleType(SVGMathView viewContainer, String value) {
        viewContainer.setScaleType(ImageView.ScaleType.valueOf((String)value));
    }

    public void receiveCommand(@Nonnull SVGMathView root, int commandId, @Nullable ReadableArray args) {
        super.receiveCommand((View)root, commandId, args);
        switch (commandId) {
            case 0: {
                root.setCSS(args.getString(0));
                break;
            }
            case 1: {
                root.addCSS(args.getString(0));
                break;
            }
            case 2: {
                root.clearCSS();
            }
        }
    }

    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> scaleType = new HashMap<String, String>();
        HashMap<String, Object> preserveAspectRatio = new HashMap<String, Object>();
        HashMap<String, String> scale = new HashMap<String, String>();
        HashMap<String, String> alignment = new HashMap<String, String>();
        for (PreserveAspectRatio.Scale scale2 : PreserveAspectRatio.Scale.values()) {
            scale.put(scale2.toString(), scale2.toString());
        }
        for (PreserveAspectRatio.Scale scale3 : PreserveAspectRatio.Alignment.values()) {
            alignment.put(scale3.toString(), scale3.toString());
        }
        preserveAspectRatio.put("Scale", scale);
        preserveAspectRatio.put("Alignment", alignment);
        preserveAspectRatio.put("BOTTOM", PreserveAspectRatio.BOTTOM.toString());
        preserveAspectRatio.put("END", PreserveAspectRatio.END.toString());
        preserveAspectRatio.put("FULLSCREEN", PreserveAspectRatio.FULLSCREEN.toString());
        preserveAspectRatio.put("FULLSCREEN_START", PreserveAspectRatio.FULLSCREEN_START.toString());
        preserveAspectRatio.put("LETTERBOX", PreserveAspectRatio.LETTERBOX.toString());
        preserveAspectRatio.put("START", PreserveAspectRatio.START.toString());
        preserveAspectRatio.put("STRETCH", PreserveAspectRatio.STRETCH.toString());
        preserveAspectRatio.put("TOP", PreserveAspectRatio.TOP.toString());
        preserveAspectRatio.put("UNSCALED", PreserveAspectRatio.UNSCALED.toString());
        for (PreserveAspectRatio.Scale scale4 : ImageView.ScaleType.values()) {
            scaleType.put(scale4.toString(), scale4.toString());
        }
        map.put("PreserveAspectRatio", preserveAspectRatio);
        map.put("ScaleType", scaleType);
        return map;
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("setCSS", 0);
        map.put("addCSS", 1);
        map.put("clearCSS", 2);
        return map;
    }

    public Map getExportedCustomBubblingEventTypeConstants() {
        return MapBuilder.builder().put((Object)"topChange", (Object)MapBuilder.of((Object)"phasedRegistrationNames", (Object)MapBuilder.of((Object)"bubbled", (Object)"onChange"))).build();
    }
}

