/*
 * Decompiled with CFR 0.152.
 */
package io.autodidact.rnmathview;

import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.NativeViewHierarchyManager;
import com.facebook.react.uimanager.UIBlock;
import com.facebook.react.uimanager.UIManagerModule;
import io.autodidact.mathjaxprovider.MathJaxProvider;
import io.autodidact.mathjaxprovider.MathJaxRequestHelper;

public class RNMathViewModule
extends ReactContextBaseJavaModule {
    public static final String TAG = "RNMathViewModule";
    private final ReactApplicationContext reactContext;

    public RNMathViewModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return TAG;
    }

    @ReactMethod
    public void getMathJax(final int tag, final ReadableArray strings, final ReadableMap options, final Promise promise) {
        try {
            ReactApplicationContext context = this.getReactApplicationContext();
            UIManagerModule uiManager = (UIManagerModule)context.getNativeModule(UIManagerModule.class);
            uiManager.addUIBlock(new UIBlock(){

                public void execute(NativeViewHierarchyManager nvhm) {
                    MathJaxProvider view = (MathJaxProvider)nvhm.resolveView(tag);
                    new MathJaxRequestHelper(view, strings, options, promise).run();
                }
            });
        }
        catch (Exception e) {
            promise.reject((Throwable)e);
        }
    }
}

