/*
 * Decompiled with CFR 0.152.
 */
package io.autodidact.mathjaxprovider;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import io.autodidact.mathjaxprovider.MathJaxProvider;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class MathJaxRequestHelper
implements MathJaxProvider.OnMessageListener {
    public static final String TAG = "MathJaxRequestHelper";
    private MathJaxProvider mView;
    private WritableArray mathJaxResponse;
    private ArrayList<String> pendingStrings = new ArrayList();
    private Promise mPromise;
    private Options mOptions;

    public MathJaxRequestHelper(MathJaxProvider view, ReadableArray strings, ReadableMap options, CompletionCallback promise) {
        this.mPromise = promise;
        this.init(view, strings, Options.getInstance(options));
    }

    public MathJaxRequestHelper(MathJaxProvider view, ReadableArray strings, ReadableMap options, Promise promise) {
        this.mPromise = promise;
        this.init(view, strings, Options.getInstance(options));
    }

    public MathJaxRequestHelper(MathJaxProvider view, ReadableArray strings, CompletionCallback promise) {
        this.mPromise = promise;
        this.init(view, strings);
    }

    public MathJaxRequestHelper(MathJaxProvider view, ReadableArray strings, Promise promise) {
        this.mPromise = promise;
        this.init(view, strings);
    }

    private void init(MathJaxProvider view, ReadableArray strings) {
        this.init(view, strings, new Options());
    }

    private void init(MathJaxProvider view, ReadableArray strings, Options options) {
        for (int i = 0; i < strings.size(); ++i) {
            this.pendingStrings.add(strings.getString(i));
        }
        this.mView = view;
        this.mathJaxResponse = Arguments.createArray();
        this.mView.addOnMessageListener(this);
        this.mOptions = options;
    }

    public void run() {
        if (this.pendingStrings.size() == 0) {
            this.reject("ReadableArray strings is empty");
        }
        for (String s : this.pendingStrings) {
            this.mView.postRequest(s);
        }
        this.mView.postDelayed(new Runnable(){

            @Override
            public void run() {
                MathJaxRequestHelper.this.reject("timeout exceeded");
            }
        }, this.mOptions.timeout);
    }

    @Override
    public void invoke(String math, String svg, double width, double height, @Nullable double apprxWidth, @Nullable double apprxHeight) {
        WritableMap map = Arguments.createMap();
        map.putString("math", math);
        map.putString("svg", svg);
        map.putDouble("width", width);
        map.putDouble("height", height);
        map.putDouble("apprxWidth", apprxWidth);
        map.putDouble("apprxHeight", apprxHeight);
        this.mathJaxResponse.pushMap((ReadableMap)map);
        this.pendingStrings.remove(math);
        if (this.pendingStrings.size() == 0) {
            this.mPromise.resolve((Object)this.mathJaxResponse);
            this.mPromise = null;
            this.destroy();
        }
    }

    private void destroy() {
        this.mView.removeOnMessageListener(this);
    }

    @Override
    public void reject() {
        this.reject("View has been destroyed");
    }

    @Override
    public void reject(Object err) {
        this.reject(err.toString());
    }

    public void reject(String message) {
        if (this.mPromise != null) {
            this.mPromise.reject("aborted", "MathJaxRequestHelper: " + message);
        }
    }

    @Override
    public void reject(Throwable err) {
        if (this.mPromise != null) {
            this.mPromise.reject(err);
        }
    }

    public static class Options {
        int timeout = 10000;

        public static Options getInstance(ReadableMap options) {
            Options mOptions = new Options();
            if (options.hasKey("timeout")) {
                mOptions.timeout = options.getInt("timeout");
            }
            return mOptions;
        }
    }

    public static interface CompletionCallback
    extends Promise {
        public void resolve(WritableArray var1);

        public void reject(String var1, String var2);

        public void reject(Throwable var1);
    }
}

